/*
 * Decompiled with CFR 0.152.
 */
package software.axios.paper.api.implementation;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.axios.api.AxiosApiPlugin;
import software.axios.api.configuration.ConfigManager;
import software.axios.api.configuration.SettingsField;
import software.axios.api.configuration.SettingsInterface;
import software.axios.paper.AxiosPlugin;
import software.axios.paper.configuration.Settings;

public class PaperConfigManager
implements ConfigManager {
    private final Map<Class<? extends SettingsInterface>, FileConfiguration> configMap = new HashMap<Class<? extends SettingsInterface>, FileConfiguration>();
    private final String configFileName = "config.yml";
    private static PaperConfigManager instance;

    public static PaperConfigManager getInstance() {
        if (instance == null) {
            instance = new PaperConfigManager();
        }
        return instance;
    }

    private PaperConfigManager() {
    }

    @Override
    public <R extends SettingsInterface> void setup(AxiosApiPlugin plugin, Class<R> settingsClazz) {
        this.reload(plugin, settingsClazz);
        AxiosPlugin.instance().debug("Setting up config manager for " + settingsClazz.getName());
        AxiosPlugin.instance().debug("The following settings are available:");
        for (SettingsInterface setting : PaperConfigManager.getSettings(settingsClazz)) {
            AxiosPlugin.instance().debug(setting.path());
        }
        this.saveToDisk(plugin, settingsClazz);
    }

    @Override
    public <R extends SettingsInterface> void reload(AxiosApiPlugin plugin, Class<R> settingsClazz) {
        YamlConfiguration config = new YamlConfiguration();
        File configFile = new File(plugin.pluginFolder(), "config.yml");
        if (configFile.exists()) {
            config = YamlConfiguration.loadConfiguration((File)configFile);
        }
        this.configMap.put(settingsClazz, (FileConfiguration)config);
        this.loadDefaults(settingsClazz, (FileConfiguration)config);
    }

    private <R extends SettingsInterface> void loadDefaults(Class<R> settingsClazz, FileConfiguration config) {
        YamlConfiguration tempConfig = new YamlConfiguration();
        for (SettingsInterface setting : PaperConfigManager.getSettings(settingsClazz)) {
            String key = setting.path().toLowerCase();
            if (config.contains(key)) {
                tempConfig.set(key, config.get(key));
            } else {
                tempConfig.set(key, setting.defaultValue());
            }
            tempConfig.addDefault(key, setting.defaultValue());
            tempConfig.setComments(key, setting.comments());
        }
        this.configMap.put(settingsClazz, (FileConfiguration)tempConfig);
    }

    private <R extends SettingsInterface> void saveToDisk(AxiosApiPlugin plugin, Class<R> settingsClazz) {
        FileConfiguration config = this.configMap.get(settingsClazz);
        File configFile = new File(plugin.pluginFolder(), "config.yml");
        try {
            config.save(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <R extends SettingsInterface> @NonNull List<SettingsInterface> getSettings(Class<R> settingsClazz) {
        Field[] fields;
        ArrayList<SettingsInterface> settingsList = new ArrayList<SettingsInterface>();
        for (Field field : fields = settingsClazz.getDeclaredFields()) {
            if (!field.getType().equals(settingsClazz)) continue;
            if (!field.isAnnotationPresent(SettingsField.class)) {
                AxiosPlugin.instance().getLogger().warning("Field " + field.getName() + " is not annotated with @SettingsField");
                continue;
            }
            try {
                settingsList.add((SettingsInterface)field.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return settingsList;
    }

    @Override
    public <T, R extends SettingsInterface> @NonNull T get(Class<R> settingsClazz, R setting) {
        Class type = setting.type();
        FileConfiguration config = this.configMap.get(settingsClazz);
        if (config == null) {
            AxiosPlugin.instance().getLogger().warning("No config found for class: " + settingsClazz.getName());
            return setting.defaultValue();
        }
        String key = setting.path();
        if (!config.contains(key)) {
            AxiosPlugin.instance().getLogger().warning("No value at given path: " + key);
            return setting.defaultValue();
        }
        Object value = config.get(key);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        AxiosPlugin.instance().getLogger().warning("Type mismatch in Config. Expected type: " + type.getSimpleName());
        return setting.defaultValue();
    }

    @Override
    public @NonNull Locale defaultLocale() {
        FileConfiguration tempConfig = this.configMap.get(Settings.class);
        String languageString = tempConfig.getString(Settings.LANGUAGE.path(), Settings.LANGUAGE.defaultValue());
        String[] language = languageString.split("_");
        assert (language.length >= 1);
        Locale.Builder builder = new Locale.Builder();
        builder.setLanguage(language[0]);
        if (language.length >= 2) {
            builder.setRegion(language[1]);
        }
        builder.setVariant("custom");
        return builder.build();
    }
}

