/*
 * Decompiled with CFR 0.152.
 */
package software.axios.paper.commands;

import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import software.axios.api.Axios;
import software.axios.api.command.CommandsInterface;
import software.axios.libs.commandapi.CommandAPI;
import software.axios.libs.commandapi.CommandAPICommand;
import software.axios.libs.commandapi.executors.ExecutorType;
import software.axios.paper.AxiosPlugin;
import software.axios.paper.i18n.Messages;

public class CommandAxios
implements CommandsInterface {
    private static CommandAxios instance;
    private final AxiosPlugin plugin = AxiosPlugin.instance();
    private final Axios axios = this.plugin.axiosApiProvider();
    private final CommandAPICommand command;
    private final List<CommandAPICommand> subCommands = new ArrayList<CommandAPICommand>();

    private CommandAxios() {
        this.command = new CommandAPICommand("axios");
        this.commandRoot();
        this.commandReload();
        this.command.withSubcommands(this.subCommands.toArray(new CommandAPICommand[0]));
    }

    public static CommandAxios instance() {
        if (instance == null) {
            instance = new CommandAxios();
        }
        return instance;
    }

    private void commandRoot() {
        this.command.withAliases("ax");
        this.command.withPermission("axios.command");
        this.command.executes((sender, args) -> {
            PluginMeta pluginMeta = this.plugin.getPluginMeta();
            assert (pluginMeta != null);
            Messages.COMMAND.sendTo((Audience)sender, this.axios.tagBuilder().add(Map.of("version", pluginMeta.getVersion(), "author", pluginMeta.getAuthors().get(0), "website", "<click:open_url:'" + pluginMeta.getWebsite() + "'>" + pluginMeta.getWebsite() + "</click>", "description", pluginMeta.getDescription(), "name", pluginMeta.getName()), true).build());
        }, new ExecutorType[0]);
    }

    private void commandReload() {
        CommandAPICommand subCommand = new CommandAPICommand("reload");
        subCommand.withAliases("r");
        subCommand.withPermission("axios.command.reload");
        subCommand.executes((sender, args) -> {
            this.plugin.reload();
            Messages.COMMAND_RELOAD.sendTo((Audience)sender);
        }, new ExecutorType[0]);
        this.subCommands.add(subCommand);
    }

    @Override
    public void register() {
        this.command.register();
    }

    @Override
    public void unregister() {
        CommandAPI.unregister(this.command.getName());
    }
}

