/*
 * Decompiled with CFR 0.152.
 */
package software.axios.paper.configuration;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.axios.api.Axios;
import software.axios.api.configuration.AxiosSettings;
import software.axios.api.configuration.SettingsField;
import software.axios.api.configuration.SettingsInterface;
import software.axios.paper.AxiosPlugin;

public class Settings<T>
implements SettingsInterface {
    @SettingsField
    public static final Settings<String> LANGUAGE = new Settings<String>("general.language", String.class, "de_DE");
    @SettingsField
    public static final Settings<Boolean> DEBUG = new Settings<Boolean>("general.debug", Boolean.class, false);
    private final AxiosPlugin plugin = AxiosPlugin.instance();
    private final Axios axios = this.plugin.axiosApiProvider();
    private final AxiosSettings<T, Settings<T>> axiosSettings;

    private Settings(String path, Class<T> type, T defaultValue) {
        this.axiosSettings = this.axios.axiosSettings(this.getClass(), path, type, defaultValue);
    }

    @Override
    public @NonNull String path() {
        return this.axiosSettings.path();
    }

    @Override
    public @NonNull List<String> comments() {
        return this.axiosSettings.comments();
    }

    @Override
    public @NonNull T get() {
        return this.axiosSettings.get(this);
    }

    @Override
    public @NonNull T defaultValue() {
        return this.axiosSettings.defaultValue();
    }

    @Override
    public @NonNull Class<T> type() {
        return this.axiosSettings.type();
    }
}

