/*
 * Decompiled with CFR 0.152.
 */
package DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.concrete;

import DiscordRoleSync.net.dv8tion.jda.api.entities.Guild;
import DiscordRoleSync.net.dv8tion.jda.api.entities.PermissionOverride;
import DiscordRoleSync.net.dv8tion.jda.api.entities.channel.attribute.IPostContainer;
import DiscordRoleSync.net.dv8tion.jda.api.entities.channel.concrete.Category;
import DiscordRoleSync.net.dv8tion.jda.api.entities.channel.concrete.MediaChannel;
import DiscordRoleSync.net.dv8tion.jda.api.entities.emoji.UnicodeEmoji;
import DiscordRoleSync.net.dv8tion.jda.api.requests.restaction.ChannelAction;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.attribute.IAgeRestrictedChannelMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.attribute.IPostContainerMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.attribute.ISlowmodeChannelMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.attribute.ITopicChannelMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.attribute.IWebhookContainerMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.middleman.StandardGuildChannelMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.utils.Checks;
import javax.annotation.Nonnull;

public interface MediaChannelMixin<T extends MediaChannelMixin<T>>
extends MediaChannel,
StandardGuildChannelMixin<T>,
IAgeRestrictedChannelMixin<T>,
ISlowmodeChannelMixin<T>,
IWebhookContainerMixin<T>,
IPostContainerMixin<T>,
ITopicChannelMixin<T> {
    @Override
    @Nonnull
    default public ChannelAction<MediaChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<MediaChannel> action = guild.createMediaChannel(this.getName()).setNSFW(this.isNSFW()).setTopic(this.getTopic()).setSlowmode(this.getSlowmode()).setAvailableTags(this.getAvailableTags());
        if (this.getRawSortOrder() != -1) {
            action.setDefaultSortOrder(IPostContainer.SortOrder.fromKey(this.getRawSortOrder()));
        }
        if (this.getDefaultReaction() instanceof UnicodeEmoji) {
            action.setDefaultReaction(this.getDefaultReaction());
        }
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParentCategory();
            action.setDefaultReaction(this.getDefaultReaction());
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.getPermissionOverrideMap().valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }
}

