/*
 * Decompiled with CFR 0.152.
 */
package DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.concrete;

import DiscordRoleSync.net.dv8tion.jda.api.Region;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Guild;
import DiscordRoleSync.net.dv8tion.jda.api.entities.PermissionOverride;
import DiscordRoleSync.net.dv8tion.jda.api.entities.channel.concrete.Category;
import DiscordRoleSync.net.dv8tion.jda.api.entities.channel.concrete.StageChannel;
import DiscordRoleSync.net.dv8tion.jda.api.requests.restaction.ChannelAction;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.attribute.IAgeRestrictedChannelMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.attribute.ISlowmodeChannelMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.attribute.IWebhookContainerMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.middleman.AudioChannelMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.channel.mixin.middleman.GuildMessageChannelMixin;
import DiscordRoleSync.net.dv8tion.jda.internal.utils.Checks;
import javax.annotation.Nonnull;

public interface StageChannelMixin<T extends StageChannelMixin<T>>
extends StageChannel,
AudioChannelMixin<T>,
GuildMessageChannelMixin<T>,
IWebhookContainerMixin<T>,
IAgeRestrictedChannelMixin<T>,
ISlowmodeChannelMixin<T> {
    @Override
    @Nonnull
    default public ChannelAction<StageChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<StageChannel> action = guild.createStageChannel(this.getName()).setBitrate(this.getBitrate());
        if (this.getRegionRaw() != null) {
            action.setRegion(Region.fromKey(this.getRegionRaw()));
        }
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParentCategory();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.getPermissionOverrideMap().valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }
}

