/*
 * Decompiled with CFR 0.152.
 */
package DiscordRoleSync.net.dv8tion.jda.internal.handle;

import DiscordRoleSync.net.dv8tion.jda.api.JDA;
import DiscordRoleSync.net.dv8tion.jda.api.entities.ScheduledEvent;
import DiscordRoleSync.net.dv8tion.jda.api.events.guild.scheduledevent.ScheduledEventCreateEvent;
import DiscordRoleSync.net.dv8tion.jda.api.utils.cache.CacheFlag;
import DiscordRoleSync.net.dv8tion.jda.api.utils.data.DataObject;
import DiscordRoleSync.net.dv8tion.jda.internal.JDAImpl;
import DiscordRoleSync.net.dv8tion.jda.internal.entities.GuildImpl;
import DiscordRoleSync.net.dv8tion.jda.internal.handle.EventCache;
import DiscordRoleSync.net.dv8tion.jda.internal.handle.SocketHandler;

public class ScheduledEventCreateHandler
extends SocketHandler {
    public ScheduledEventCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        if (!this.getJDA().isCacheFlagSet(CacheFlag.SCHEDULED_EVENTS)) {
            return null;
        }
        long guildId = content.getUnsignedLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        if (guild == null) {
            EventCache.LOG.debug("Caching SCHEDULED_EVENT_CREATE for uncached guild with id {}", (Object)guildId);
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
            return null;
        }
        ScheduledEvent event = this.getJDA().getEntityBuilder().createScheduledEvent(guild, content);
        this.getJDA().handleEvent(new ScheduledEventCreateEvent((JDA)this.getJDA(), this.responseNumber, event));
        return null;
    }
}

