/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync;

import DiscordRoleSync.net.dv8tion.jda.api.exceptions.InvalidTokenException;
import DiscordRoleSync.org.bstats.bukkit.Metrics;
import DiscordRoleSync.org.bstats.charts.SimplePie;
import DiscordRoleSync.org.bstats.charts.SingleLineChart;
import dev.nicho.rolesync.bot.SyncBot;
import dev.nicho.rolesync.config.linter.ConfigLinter;
import dev.nicho.rolesync.config.linter.LintResult;
import dev.nicho.rolesync.config.migrations.ConfigMigration;
import dev.nicho.rolesync.config.migrations.ConfigMigrator;
import dev.nicho.rolesync.db.DatabaseHandler;
import dev.nicho.rolesync.db.MySQLHandler;
import dev.nicho.rolesync.db.SQLiteHandler;
import dev.nicho.rolesync.integrations.placeholders.RoleSyncPlaceholderExpansion;
import dev.nicho.rolesync.listeners.PlayerJoinListener;
import dev.nicho.rolesync.listeners.WhitelistLoginListener;
import dev.nicho.rolesync.minecraft.UUIDMode;
import dev.nicho.rolesync.util.caching.MetricCacher;
import dev.nicho.rolesync.util.plugin_meta.PluginVersion;
import dev.nicho.rolesync.util.vault.VaultAPI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.milkbowl.vault.permission.Permission;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.intellij.lang.annotations.PrintFormat;

public class RoleSync
extends JavaPlugin {
    private static final String defaultLanguage = "en_US";
    private YamlConfiguration language = null;
    private String configError = null;
    private boolean configLoaded = false;
    private DatabaseHandler db = null;
    private SyncBot bot = null;
    private VaultAPI vault = null;
    private String chatPrefix = null;
    private final Map<String, MetricCacher<?>> metricCaches = new HashMap();

    public void onLoad() {
        try {
            File langFolder;
            File libFolder = new File(this.getDataFolder(), "lib");
            if (libFolder.exists() && libFolder.isDirectory()) {
                this.getLogger().info("Deleting old lib folder");
                FileUtils.deleteDirectory(libFolder);
            }
            if ((langFolder = new File(this.getDataFolder(), "language")).exists() && langFolder.isDirectory()) {
                this.getLogger().info("Deleting old language folder");
                FileUtils.deleteDirectory(langFolder);
            }
            Files.createDirectories(Paths.get(this.getDataFolder().getPath(), "translations"), new FileAttribute[0]);
        }
        catch (Exception e) {
            this.getLogger().severe("An error occurred while updating old plugin configuration.\n" + e.getMessage());
            this.setEnabled(false);
        }
        try {
            LintResult lintResult;
            this.getLogger().info("Reading config.yml");
            this.saveDefaultConfig();
            ConfigLinter linter = new ConfigLinter(this);
            this.getLogger().info("Attempting to migrate config.yml");
            ConfigMigrator migrator = new ConfigMigrator(this);
            FileConfiguration updatedConfig = migrator.run(this.getConfig());
            if (updatedConfig != null) {
                this.getLogger().info("Config file has been migrated. Validating...");
                lintResult = linter.run((Configuration)updatedConfig);
                if (!lintResult.isValid()) {
                    throw new InvalidConfigurationException("Migrated config.yml failed to validate: " + lintResult);
                }
                this.getLogger().info("Migrated config.yml has been validated.");
                this.getConfig().save(Paths.get(this.getDataFolder().getPath(), String.format("config-bkp-%d-%d.yml", this.getConfig().getInt("configVersion", 1), System.currentTimeMillis())).toString());
                updatedConfig.save(Paths.get(this.getDataFolder().getPath(), "config.yml").toString());
                this.reloadConfig();
                this.getLogger().info("Done migrating configs!");
            } else {
                this.getLogger().info("No configs to migrate.");
            }
            this.getLogger().info("Validating config.yml");
            lintResult = linter.run((Configuration)this.getConfig());
            if (!lintResult.isValid()) {
                throw new InvalidConfigurationException("config.yml failed to validate: " + lintResult);
            }
            this.getLogger().info("config.yml has been validated!");
            this.loadLang();
        }
        catch (InvalidConfigurationException e) {
            this.configError = "One of the yml files is invalid.\n" + e.getMessage();
            this.getLogger().severe(this.configError);
            this.setEnabled(false);
            return;
        }
        catch (IOException e) {
            this.getLogger().severe("An error occurred while loading the yml files.\n" + e);
            this.setEnabled(false);
            return;
        }
        this.chatPrefix = this.getConfig().getString("chatPrefix.text", "[DRS]") + " ";
        this.configLoaded = true;
    }

    public void onEnable() {
        if (!this.configLoaded) {
            this.getLogger().severe("Not enabling DiscordRoleSync since the config files failed to load. Make sure no errors are shown when loading the config and language files.");
            if (this.configError != null) {
                this.getLogger().severe(this.configError);
            }
            this.setEnabled(false);
            return;
        }
        try {
            this.db = this.getConfig().getString("database.type").equalsIgnoreCase("mysql") ? new MySQLHandler(this, this.getConfig().getString("database.mysql.dbhost"), this.getConfig().getInt("database.mysql.dbport"), this.getConfig().getString("database.mysql.dbname"), this.getConfig().getString("database.mysql.dbuser"), this.getConfig().getString("database.mysql.dbpass")) : new SQLiteHandler(this, new File(this.getDataFolder(), "database.db"));
            RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Permission.class);
            if (rsp == null) {
                throw new IllegalStateException("Vault is not loaded.");
            }
            this.vault = new VaultAPI(this, (Permission)rsp.getProvider());
            this.bot = new SyncBot(this);
            this.startBot();
        }
        catch (IOException | SQLException e) {
            this.getLogger().severe("Error setting up database.\n" + e.getMessage());
            this.setEnabled(false);
            return;
        }
        catch (IllegalStateException e) {
            this.getLogger().severe("Vault is not installed/loaded. Please install vault.");
            this.setEnabled(false);
            return;
        }
        if (this.getConfig().getBoolean("manageWhitelist")) {
            this.getServer().getPluginManager().registerEvents((Listener)new WhitelistLoginListener(this), (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.registerMetrics();
        try {
            this.checkLatestVersion();
        }
        catch (IOException e) {
            this.getLogger().warning("Unable to run checks on the installed plugin version.\n" + e.getMessage());
        }
        if (this.getIntegrationEnabled("PlaceholderAPI")) {
            new RoleSyncPlaceholderExpansion(this).register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisable() {
        RoleSync roleSync = this;
        synchronized (roleSync) {
            if (this.bot != null) {
                this.bot.shutdown();
            }
            for (MetricCacher<?> cacher : this.metricCaches.values()) {
                cacher.stop();
            }
        }
    }

    public void registerMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 7533);
        metrics.addCustomChart(new SimplePie("used_language", () -> this.getConfig().getString("language")));
        metrics.addCustomChart(new SimplePie("whitelist_enabled", () -> String.valueOf(this.getConfig().getBoolean("manageWhitelist"))));
        metrics.addCustomChart(new SimplePie("linked_role", () -> String.valueOf(this.getConfig().getBoolean("giveLinkedRole"))));
        metrics.addCustomChart(new SimplePie("show_players_online", () -> String.valueOf(this.getConfig().getBoolean("botActivity.enable"))));
        metrics.addCustomChart(new SimplePie("require_verification", () -> String.valueOf(this.getConfig().getBoolean("requireVerification"))));
        metrics.addCustomChart(new SimplePie("user_uuid_mode", () -> UUIDMode.fromCaseInsensitive(this.getConfig().getString("userUUIDMode")).toString()));
        metrics.addCustomChart(new SimplePie("change_nicknames", () -> {
            if (!this.getConfig().getString("discordRename.template").isEmpty()) {
                return "Custom";
            }
            return "No";
        }));
        metrics.addCustomChart(new SimplePie("database_type", () -> {
            if (this.getConfig().getString("database.type").equalsIgnoreCase("mysql")) {
                return "MySQL";
            }
            return "SQLite";
        }));
        metrics.addCustomChart(new SimplePie("changed_alternative_server", () -> {
            if (this.getConfig().getString("alternativeServer").isEmpty()) {
                return "Not changed";
            }
            return "Changed";
        }));
        metrics.addCustomChart(new SimplePie("permissions_plugin", () -> {
            String permPlugin = this.vault.getPermPluginName();
            if (permPlugin != null && !permPlugin.isEmpty()) {
                return permPlugin;
            }
            return "unknown/other";
        }));
        metrics.addCustomChart(new SimplePie("use_embeds", () -> String.valueOf(this.getConfig().getBoolean("embed.useEmbed"))));
        metrics.addCustomChart(new SimplePie("enabled_geyser_support", () -> String.valueOf(this.getConfig().getBoolean("experimental.geyser.enableGeyserSupport", false))));
        metrics.addCustomChart(new SimplePie("integration_placeholder_api", () -> String.valueOf(this.getIntegrationEnabled("PlaceholderAPI"))));
        String linkedUsersChartId = "linked_users";
        MetricCacher<Integer> linkedUsersCache = new MetricCacher<Integer>(this, () -> this.db.getLinkedUserCount(), 12000L);
        this.metricCaches.put(linkedUsersChartId, linkedUsersCache);
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> metrics.addCustomChart(new SingleLineChart(linkedUsersChartId, linkedUsersCache::getValue)), 200L);
    }

    private void checkLatestVersion() throws IOException {
        String installedVersion = this.getDescription().getVersion();
        PluginVersion v = new PluginVersion(this);
        String latestVersion = v.getLatestVersion();
        PluginVersion.VersionType versionType = PluginVersion.getVersionType(installedVersion);
        if (versionType != PluginVersion.VersionType.RELEASE) {
            this.getLogger().warning(this.language.getString("nonReleaseVersion.running." + versionType.toString()));
            return;
        }
        if (v.isOldRelease(installedVersion)) {
            this.getLogger().warning(String.format("%s %s %s, %s %s", this.language.getString("notLatestVersion"), this.language.getString("current"), installedVersion, this.language.getString("latest"), latestVersion));
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (args2.length < 1) {
            sender.sendMessage(ChatColor.BLUE + this.chatPrefix + ChatColor.RESET + this.language.getString("usage") + "\n" + ChatColor.BLUE + this.chatPrefix + ChatColor.RESET + "/drs reload: " + this.language.getString("drsReloadDescription") + "\n" + ChatColor.BLUE + this.chatPrefix + ChatColor.RESET + "/drs botrestart: " + this.language.getString("drsBotRestartDescription") + "\n" + ChatColor.BLUE + this.chatPrefix + ChatColor.RESET + "/drs verify: " + this.language.getString("drsVerifyDescription"));
            return true;
        }
        if (args2[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("discordrolesync.reload")) {
                sender.sendMessage(ChatColor.BLUE + this.chatPrefix + ChatColor.RED + this.language.getString("noPermissionError"));
                return false;
            }
            this.reloadConfig();
            this.loadLang();
            sender.sendMessage(ChatColor.BLUE + this.chatPrefix + ChatColor.GREEN + this.language.getString("reloadComplete"));
            return true;
        }
        if (args2[0].equalsIgnoreCase("botrestart")) {
            if (!sender.hasPermission("discordrolesync.botrestart")) {
                sender.sendMessage(ChatColor.BLUE + this.chatPrefix + ChatColor.RED + this.language.getString("noPermissionError"));
                return false;
            }
            this.bot.shutdown();
            this.startBot();
            sender.sendMessage(ChatColor.BLUE + this.chatPrefix + ChatColor.GREEN + this.language.getString("botRestarted"));
            return true;
        }
        if (args2[0].equalsIgnoreCase("verify")) {
            if (sender instanceof Player) {
                this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                    try {
                        DatabaseHandler.LinkedUserInfo userInfo = this.db.getLinkedUserInfo(((Player)sender).getUniqueId().toString());
                        if (userInfo == null) {
                            sender.sendMessage(ChatColor.BLUE + this.chatPrefix + ChatColor.RESET + this.language.getString("pleaseLink") + " " + this.getConfig().getString("discordUrl"));
                        } else if (!userInfo.verified) {
                            sender.sendMessage(ChatColor.BLUE + this.chatPrefix + ChatColor.RESET + this.language.getString("verification.instructions").replace("$verify_command_name$", this.getConfig().getString("commandNames.verify", "verify")).replace("$verification_code$", ChatColor.AQUA + String.valueOf(userInfo.code) + ChatColor.RESET));
                        } else {
                            sender.sendMessage(ChatColor.BLUE + this.chatPrefix + ChatColor.RESET + this.language.getString("verification.alreadyVerified"));
                        }
                    }
                    catch (SQLException e) {
                        sender.sendMessage(ChatColor.RED + this.language.getString("commandError"));
                        this.getLogger().severe("An error occurred while getting linked user info.\n" + e.getMessage());
                    }
                });
                return true;
            }
            sender.sendMessage(ChatColor.BLUE + this.chatPrefix + ChatColor.RED + "This command can only be used in game.");
            return false;
        }
        return true;
    }

    private void loadLang() {
        this.getLogger().info("Updating custom translation files");
        int updated = this.updateLangFiles();
        this.getLogger().info(String.format("Updated %d language file%s", updated, updated == 1 ? "" : "s"));
        String lang = this.getConfig().getString("language");
        this.getLogger().info("Reading language file for " + lang);
        this.language = this.loadLangFile(lang);
        this.getLogger().info("Language file loaded! " + this.language.getString("hello"));
    }

    private int updateLangFiles() {
        YamlConfiguration english;
        try (InputStream stream = this.getResource(String.format("language/%s.yml", defaultLanguage));
             InputStreamReader reader = new InputStreamReader(stream);){
            english = YamlConfiguration.loadConfiguration((Reader)reader);
        }
        catch (Exception e) {
            throw new RuntimeException("Default language file not found in the .jar: " + e.getMessage());
        }
        Set keys = english.getKeys(true);
        int updated = 0;
        File languageFolder = new File(this.getDataFolder(), "translations");
        if (!languageFolder.isDirectory()) {
            return 0;
        }
        Iterator<File> dir = FileUtils.iterateFiles(languageFolder, new String[]{"yml"}, false);
        while (dir.hasNext()) {
            File file = dir.next();
            String language = file.getName();
            YamlConfiguration loaded = YamlConfiguration.loadConfiguration((File)file);
            ArrayList<String> missingKeys = new ArrayList<String>();
            for (String key : keys) {
                if (loaded.contains(key)) continue;
                missingKeys.add(key);
            }
            if (missingKeys.isEmpty()) continue;
            this.getLogger().info(String.format("Language file %s is missing keys, updating...", language));
            String languageResource = String.format("language/%s", language);
            try (InputStream resourceStream = this.getResource(languageResource);){
                if (resourceStream == null) {
                    languageResource = "language/en_US.yml";
                }
            }
            catch (Exception e) {
                languageResource = "language/en_US.yml";
            }
            ConfigMigration migration = new ConfigMigration(languageResource);
            FileConfiguration newConfig = migration.run((FileConfiguration)loaded);
            try {
                newConfig.save(Paths.get(this.getDataFolder().getPath(), "translations", language).toString());
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to update language file." + e.getMessage());
                continue;
            }
            ++updated;
        }
        return updated;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private YamlConfiguration loadLangFile(String language) {
        File langFile = new File(this.getDataFolder(), String.format("translations/%s.yml", language));
        if (langFile.exists()) {
            this.getLogger().info(String.format("Found custom translation %s.yml", language));
            return YamlConfiguration.loadConfiguration((File)langFile);
        }
        try (InputStream stream = this.getResource(String.format("language/%s.yml", language));){
            YamlConfiguration yamlConfiguration;
            try (InputStreamReader reader = new InputStreamReader(stream);){
                yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
            }
            return yamlConfiguration;
        }
        catch (Exception e) {
            if (language.equals(defaultLanguage)) {
                throw new IllegalStateException(String.format("%s.yml is the default language and was not found. This is a bug. Please contact the developer.", defaultLanguage));
            }
            this.getLogger().warning(String.format("Language file %s.yml does not exist in jar or in custom translation folder. Is it supported? Defaulting to %s.", language, defaultLanguage));
            return this.loadLangFile(defaultLanguage);
        }
    }

    private void startBot() {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                this.bot.start();
            }
            catch (InvalidTokenException | IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Error logging in. Did you set your token in config.yml?", e);
                this.getServer().getScheduler().runTask((Plugin)this, () -> this.setEnabled(false));
            }
        });
    }

    public FileConfiguration getLanguage() {
        return this.language;
    }

    public DatabaseHandler getDb() {
        return this.db;
    }

    public VaultAPI getVault() {
        return this.vault;
    }

    public SyncBot getBot() {
        return this.bot;
    }

    public boolean getIntegrationEnabled(String integration) {
        return Bukkit.getPluginManager().isPluginEnabled(integration) && this.getConfig().getBoolean("integrations.plugins." + integration, true);
    }

    public void debugLog(@PrintFormat String format, Object ... args2) {
        boolean isDevVersion;
        String installedVersion = this.getDescription().getVersion();
        PluginVersion.VersionType versionType = PluginVersion.getVersionType(installedVersion);
        boolean bl = isDevVersion = versionType != PluginVersion.VersionType.RELEASE && versionType != PluginVersion.VersionType.RELEASE_CANDIDATE;
        if (isDevVersion || this.getConfig().getBoolean("enableDebugLogging", false)) {
            this.getLogger().warning(String.format("[DEBUG] " + format, args2));
        }
    }
}

