/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.bot;

import DiscordRoleSync.net.dv8tion.jda.api.JDA;
import DiscordRoleSync.net.dv8tion.jda.api.JDABuilder;
import DiscordRoleSync.net.dv8tion.jda.api.Permission;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Activity;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Guild;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Member;
import DiscordRoleSync.net.dv8tion.jda.api.entities.User;
import DiscordRoleSync.net.dv8tion.jda.api.events.session.ReadyEvent;
import DiscordRoleSync.net.dv8tion.jda.api.events.session.ShutdownEvent;
import DiscordRoleSync.net.dv8tion.jda.api.exceptions.InvalidTokenException;
import DiscordRoleSync.net.dv8tion.jda.api.hooks.ListenerAdapter;
import DiscordRoleSync.net.dv8tion.jda.api.requests.GatewayIntent;
import DiscordRoleSync.net.dv8tion.jda.api.utils.cache.CacheFlag;
import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.bot.discord.DiscordAgent;
import dev.nicho.rolesync.bot.listeners.MemberEventsListener;
import dev.nicho.rolesync.bot.listeners.SlashCommandListener;
import dev.nicho.rolesync.db.DatabaseHandler;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Objects;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncBot
extends ListenerAdapter {
    private final RoleSync plugin;
    private final DiscordAgent discordAgent;
    private JDA jda = null;
    private BukkitTask presenceTimer;

    public SyncBot(RoleSync plugin) {
        this.plugin = plugin;
        this.discordAgent = new DiscordAgent(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws InvalidTokenException, IllegalStateException {
        this.plugin.getLogger().info("Initializing bot");
        JDABuilder builder = JDABuilder.create(this.plugin.getConfig().getString("bot.token"), GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_MODERATION).disableCache(CacheFlag.EMOJI, CacheFlag.STICKER, CacheFlag.ONLINE_STATUS, CacheFlag.SCHEDULED_EVENTS, CacheFlag.VOICE_STATE, CacheFlag.ACTIVITY, CacheFlag.CLIENT_STATUS);
        SyncBot syncBot = this;
        synchronized (syncBot) {
            this.jda = builder.build();
        }
        SlashCommandListener slashCommandListener = new SlashCommandListener(this.plugin, this.jda);
        this.jda.addEventListener(this, new MemberEventsListener(this.plugin), slashCommandListener);
        this.plugin.getLogger().info("Updating bot commands");
        this.jda.updateCommands().addCommands(slashCommandListener.getCommandData()).queue(cmds -> this.plugin.getLogger().info("Updated bot commands successfully"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stopTimers();
        if (this.jda == null) {
            return;
        }
        SyncBot syncBot = this;
        synchronized (syncBot) {
            this.plugin.getLogger().info("Shutting down bot...");
            this.jda.shutdown();
            try {
                if (!this.jda.awaitShutdown(Duration.ofSeconds(2L))) {
                    this.plugin.getLogger().info("Forcing bot to shut down");
                    this.jda.shutdownNow();
                    this.jda.awaitShutdown();
                }
                this.plugin.getLogger().info("Bot has been shut down");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReady(ReadyEvent event) {
        this.stopTimers();
        this.plugin.getLogger().info("Logged in: " + event.getJDA().getSelfUser().getName());
        if (this.plugin.getConfig().getBoolean("botActivity.enable")) {
            Server server = this.plugin.getServer();
            SyncBot syncBot = this;
            synchronized (syncBot) {
                this.presenceTimer = server.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
                    String template = this.plugin.getConfig().getString("botActivity.status");
                    String msg = template.replace("$online_players$", String.valueOf(server.getOnlinePlayers().size())).replace("$total_players$", String.valueOf(server.getMaxPlayers()));
                    if (template.contains("$linked_players$")) {
                        try {
                            msg = msg.replace("$linked_players$", String.valueOf(this.plugin.getDb().getLinkedUserCount()));
                        }
                        catch (SQLException e) {
                            this.plugin.getLogger().warning("Error getting linked user count to set on the Bot's activity: " + e.getMessage());
                        }
                    }
                    if (this.plugin.getIntegrationEnabled("PlaceholderAPI")) {
                        msg = PlaceholderAPI.setPlaceholders(null, (String)msg);
                    }
                    this.jda.getPresence().setActivity(Activity.customStatus(msg));
                }, 0L, 3600L);
            }
        }
        try {
            this.plugin.getDb().forAllLinkedUsers(userInfo -> Objects.requireNonNull(this.jda.getGuildById(this.plugin.getConfig().getString("bot.server"))).retrieveMemberById(userInfo.discordId).queue(member -> {
                if (member != null) {
                    if (userInfo.verified || !this.plugin.getConfig().getBoolean("requireVerification")) {
                        this.discordAgent.giveRoleAndNickname((Member)member, userInfo.username, userInfo.uuid);
                    } else {
                        this.discordAgent.removeRoleAndNickname((Member)member);
                    }
                    this.discordAgent.checkMemberRoles((Member)member, (DatabaseHandler.LinkedUserInfo)userInfo);
                }
            }, error -> {}));
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("An error occurred while checking all users.\n" + e.getMessage());
        }
        Guild guild = this.jda.getGuildById(this.plugin.getConfig().getString("bot.server"));
        if (guild == null) {
            this.plugin.getLogger().severe("Bot is not a member of the configured server. This plugin will not work correctly.");
        } else {
            Permission[] requiredPermissions;
            for (Permission p : requiredPermissions = new Permission[]{Permission.MANAGE_ROLES}) {
                if (guild.getSelfMember().hasPermission(new Permission[0])) continue;
                this.plugin.getLogger().severe("Bot does not have required permission" + (Object)((Object)p) + ". This plugin will not work correctly.");
            }
        }
    }

    @Override
    public void onShutdown(@NotNull ShutdownEvent event) {
        this.stopTimers();
    }

    public JDA getJDA() {
        return this.jda;
    }

    public DiscordAgent getAgent() {
        return this.discordAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimers() {
        SyncBot syncBot = this;
        synchronized (syncBot) {
            if (this.presenceTimer != null) {
                this.presenceTimer.cancel();
                this.presenceTimer = null;
            }
        }
    }

    @Nullable
    public String getDiscordUsername(String discordId) {
        User user = this.jda.getUserById(discordId);
        if (user == null) {
            return null;
        }
        return user.getName();
    }

    @Nullable
    public String getDiscordDisplayName(String discordId) {
        User user = this.jda.getUserById(discordId);
        if (user == null) {
            return null;
        }
        return user.getEffectiveName();
    }
}

