/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.bot.discord;

import DiscordRoleSync.net.dv8tion.jda.api.EmbedBuilder;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Member;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Message;
import DiscordRoleSync.net.dv8tion.jda.api.entities.MessageEmbed;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Role;
import DiscordRoleSync.net.dv8tion.jda.api.exceptions.PermissionException;
import DiscordRoleSync.net.dv8tion.jda.api.interactions.InteractionHook;
import DiscordRoleSync.net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.bot.discord.ReplyType;
import dev.nicho.rolesync.db.DatabaseHandler;
import java.awt.Color;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class DiscordAgent {
    private final RoleSync plugin;

    public DiscordAgent(RoleSync plugin) {
        this.plugin = plugin;
    }

    public void checkMemberRoles(Member member) {
        try {
            this.checkMemberRoles(member, this.plugin.getDb().getLinkedUserInfo(member.getId()));
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("An error occurred while looking for the UUID of a user.\n" + e.getMessage());
        }
    }

    public void checkMemberRoles(Member member, DatabaseHandler.LinkedUserInfo userInfo) {
        try {
            ConfigurationSection perms = this.plugin.getConfig().getConfigurationSection("groups");
            if (userInfo == null) {
                return;
            }
            if (this.plugin.getConfig().getBoolean("requireVerification") && !userInfo.verified) {
                this.setPermissions(userInfo.uuid, null);
            } else {
                ArrayList<String> permsToHave = new ArrayList<String>();
                for (String perm : perms.getKeys(true)) {
                    boolean hasRole;
                    if (perms.getStringList(perm).isEmpty() || !(hasRole = this.hasRoleFromList(member, perms.getStringList(perm)))) continue;
                    permsToHave.add(perm);
                }
                this.setPermissions(userInfo.uuid, permsToHave);
            }
            if (this.plugin.getConfig().getBoolean("manageWhitelist")) {
                if (this.hasRoleFromList(member, this.plugin.getConfig().getStringList("whitelistRoles"))) {
                    this.plugin.getDb().addToWhitelist(userInfo.uuid);
                } else {
                    this.plugin.getDb().removeFromWhitelist(userInfo.uuid);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("An error occurred while trying to check roles for the user.\n" + e.getMessage());
        }
    }

    public void setPermissions(String uuid, List<String> groupsToHave) {
        Runnable task = () -> this.plugin.getVault().setGroups(uuid, groupsToHave);
        if (this.plugin.getServer().getPluginManager().getPlugin("PermissionsEx") != null) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, task);
        } else {
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, task);
        }
    }

    public void removeRoleAndNickname(Member member) {
        try {
            if (this.plugin.getConfig().getBoolean("giveLinkedRole")) {
                Role role = member.getGuild().getRoleById(this.plugin.getConfig().getString("linkedRole"));
                if (role == null) {
                    this.plugin.getLogger().warning("Linked role does not exist.");
                    return;
                }
                member.getGuild().removeRoleFromMember(member, role).queue(null, error -> this.plugin.getLogger().warning("Error while adding role: " + error.getMessage()));
            }
        }
        catch (PermissionException e) {
            this.plugin.getLogger().warning("Bot has no permissions to remove roles for a user.");
        }
        try {
            if (!this.plugin.getConfig().getString("discordRename.template").isEmpty()) {
                member.modifyNickname(null).queue(null, error -> this.plugin.getLogger().warning("Error while changing user's nickname: " + error.getMessage()));
            }
        }
        catch (PermissionException e) {
            this.plugin.getLogger().warning("Bot has no permissions to reset nickname of a user.");
        }
    }

    public void giveRoleAndNickname(Member member, String mcUser, String uuid) {
        try {
            List excludedRoles = this.plugin.getConfig().getStringList("discordRename.excludedRoles");
            String renameTemplate = this.plugin.getConfig().getString("discordRename.template");
            if (mcUser != null && !renameTemplate.isEmpty() && !this.hasRoleFromList(member, excludedRoles)) {
                OfflinePlayer player;
                String nick = renameTemplate.replace("$discord_name$", member.getUser().getEffectiveName()).replace("$minecraft_name$", mcUser);
                if (this.plugin.getIntegrationEnabled("PlaceholderAPI") && renameTemplate.contains("%") && (player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid))) != null) {
                    nick = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)nick);
                }
                nick = nick.codePoints().limit(32L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
                member.modifyNickname(nick).queue(null, error -> this.plugin.getLogger().warning("Error while changing user's nickname: " + error.getMessage()));
            }
        }
        catch (PermissionException e) {
            this.plugin.getLogger().warning("Bot has no permissions to change nicknames for a user.");
        }
        try {
            if (this.plugin.getConfig().getBoolean("giveLinkedRole")) {
                Role role = member.getGuild().getRoleById(this.plugin.getConfig().getString("linkedRole"));
                if (role == null) {
                    throw new IllegalStateException("Linked role does not exist");
                }
                member.getGuild().addRoleToMember(member, role).queue(null, error -> this.plugin.getLogger().warning("Error while adding role: " + error.getMessage()));
            }
        }
        catch (PermissionException e) {
            this.plugin.getLogger().warning("Bot has no permissions to add roles for a user.");
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().severe("Error while giving user the linked role: " + e.getMessage());
        }
    }

    public WebhookMessageCreateAction<Message> buildReply(InteractionHook hook, String message) {
        return this.buildReply(hook, ReplyType.INFO, message);
    }

    public WebhookMessageCreateAction<Message> buildReply(InteractionHook hook, ReplyType replyType, String message) {
        if (!this.plugin.getConfig().getBoolean("embed.useEmbed", false)) {
            return hook.sendMessage(message);
        }
        String embedTitle = this.plugin.getConfig().getString("embed.title");
        EmbedBuilder builder = new EmbedBuilder().setTitle(embedTitle).setDescription(message);
        String colorConfig = this.plugin.getConfig().getString(String.format("embed.colors.%s", new Object[]{replyType}), "WHITE");
        return hook.sendMessageEmbeds(builder.setColor(this.getColorFromString(colorConfig)).build(), new MessageEmbed[0]);
    }

    private Color getColorFromString(String colorString) {
        if (colorString.matches("^#[0-9A-Fa-f]{1,6}$")) {
            return Color.decode(colorString);
        }
        try {
            Field field = Class.forName("java.awt.Color").getField(colorString);
            return (Color)field.get(null);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error while sending message with embed: embed color " + colorString + " is invalid. Defaulting to WHITE.");
            return Color.WHITE;
        }
    }

    private boolean hasRoleFromList(Member member, List<String> roleList) {
        if (member == null) {
            return false;
        }
        for (String roleID : roleList) {
            Role roleFound = member.getRoles().stream().filter(role -> role.getId().equals(roleID)).findFirst().orElse(null);
            if (roleFound == null) continue;
            return true;
        }
        return false;
    }
}

