/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.bot.discord;

import DiscordRoleSync.net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import DiscordRoleSync.net.dv8tion.jda.api.interactions.commands.build.Commands;
import DiscordRoleSync.net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import java.util.function.Consumer;
import java.util.function.Function;

public class DiscordCommand {
    private final String name;
    private final String description;
    private final Consumer<SlashCommandInteractionEvent> implementation;
    private final Function<SlashCommandData, SlashCommandData> modifiers;

    public DiscordCommand(String name, String description, Function<SlashCommandData, SlashCommandData> modifiers, Consumer<SlashCommandInteractionEvent> implementation) {
        this.name = name;
        this.description = description;
        this.modifiers = modifiers;
        this.implementation = implementation;
    }

    protected DiscordCommand(String name, String description, Consumer<SlashCommandInteractionEvent> implementation) {
        this(name, description, null, implementation);
    }

    public void run(SlashCommandInteractionEvent event) {
        if (!event.getName().equalsIgnoreCase(this.name)) {
            throw new IllegalArgumentException("Incorrect event received for command " + this.name + ": " + event.getName());
        }
        this.implementation.accept(event);
    }

    public SlashCommandData getCommandData() {
        SlashCommandData data = Commands.slash(this.name, this.description);
        if (this.modifiers == null) {
            return data;
        }
        return this.modifiers.apply(data);
    }
}

