/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.bot.listeners;

import DiscordRoleSync.net.dv8tion.jda.api.events.guild.member.GuildMemberJoinEvent;
import DiscordRoleSync.net.dv8tion.jda.api.events.guild.member.GuildMemberRemoveEvent;
import DiscordRoleSync.net.dv8tion.jda.api.events.guild.member.GuildMemberRoleAddEvent;
import DiscordRoleSync.net.dv8tion.jda.api.events.guild.member.GuildMemberRoleRemoveEvent;
import DiscordRoleSync.net.dv8tion.jda.api.hooks.ListenerAdapter;
import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.bot.discord.DiscordAgent;
import dev.nicho.rolesync.db.DatabaseHandler;
import java.sql.SQLException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MemberEventsListener
extends ListenerAdapter {
    private final RoleSync plugin;
    private final DiscordAgent discordAgent;

    public MemberEventsListener(RoleSync plugin) {
        this.plugin = plugin;
        this.discordAgent = new DiscordAgent(plugin);
    }

    @Override
    public void onGuildMemberRoleAdd(GuildMemberRoleAddEvent event) {
        this.discordAgent.checkMemberRoles(event.getMember());
    }

    @Override
    public void onGuildMemberRoleRemove(GuildMemberRoleRemoveEvent event) {
        this.discordAgent.checkMemberRoles(event.getMember());
    }

    @Override
    public void onGuildMemberJoin(GuildMemberJoinEvent event) {
        try {
            DatabaseHandler.LinkedUserInfo userInfo = this.plugin.getDb().getLinkedUserInfo(event.getMember().getId());
            if (userInfo != null && (!this.plugin.getConfig().getBoolean("requireVerification") || userInfo.verified)) {
                this.discordAgent.giveRoleAndNickname(event.getMember(), userInfo.username, userInfo.uuid);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("An error occurred while checking if a new member is linked.\n" + e.getMessage());
        }
    }

    @Override
    public void onGuildMemberRemove(@NotNull GuildMemberRemoveEvent event) {
        try {
            DatabaseHandler.LinkedUserInfo userInfo = this.plugin.getDb().getLinkedUserInfo(Objects.requireNonNull(event.getMember()).getId());
            if (userInfo != null) {
                this.plugin.getDb().removeFromWhitelist(userInfo.uuid);
                this.discordAgent.setPermissions(userInfo.uuid, null);
            }
        }
        catch (NullPointerException | SQLException e) {
            this.plugin.getLogger().severe("An error occurred while removing kicked/banned/left member from whitelist.\n" + e.getMessage());
        }
    }
}

