/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.bot.listeners;

import DiscordRoleSync.net.dv8tion.jda.api.JDA;
import DiscordRoleSync.net.dv8tion.jda.api.Permission;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Guild;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Member;
import DiscordRoleSync.net.dv8tion.jda.api.entities.User;
import DiscordRoleSync.net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import DiscordRoleSync.net.dv8tion.jda.api.hooks.ListenerAdapter;
import DiscordRoleSync.net.dv8tion.jda.api.interactions.InteractionContextType;
import DiscordRoleSync.net.dv8tion.jda.api.interactions.InteractionHook;
import DiscordRoleSync.net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import DiscordRoleSync.net.dv8tion.jda.api.interactions.commands.OptionMapping;
import DiscordRoleSync.net.dv8tion.jda.api.interactions.commands.OptionType;
import DiscordRoleSync.net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.bot.discord.DiscordAgent;
import dev.nicho.rolesync.bot.discord.DiscordCommand;
import dev.nicho.rolesync.bot.discord.ReplyType;
import dev.nicho.rolesync.bot.exceptions.UserErrorException;
import dev.nicho.rolesync.db.DatabaseHandler;
import dev.nicho.rolesync.minecraft.UUIDMode;
import dev.nicho.rolesync.minecraft.UUIDType;
import dev.nicho.rolesync.minecraft.UserSearch;
import dev.nicho.rolesync.minecraft.UserSearchResult;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SlashCommandListener
extends ListenerAdapter {
    private final RoleSync plugin;
    private final JDA jda;
    private final DiscordAgent discordAgent;
    private final UserSearch userSearch;
    private final Map<String, DiscordCommand> commands;

    public SlashCommandListener(RoleSync plugin, JDA jda) {
        this.plugin = plugin;
        this.jda = jda;
        this.discordAgent = new DiscordAgent(plugin);
        this.userSearch = new UserSearch(plugin);
        this.commands = new HashMap<String, DiscordCommand>();
        String link = plugin.getConfig().getString("commandNames.link", "link");
        this.commands.put(link, new DiscordCommand(link, plugin.getLanguage().getString("commandDescriptions.link"), cmd -> this.maybeAddOfflineModeArgument(cmd.setContexts(InteractionContextType.GUILD).addOption(OptionType.STRING, "minecraft_username", plugin.getLanguage().getString("commandArguments.minecraftUsername.link"), true)), event -> {
            boolean ephemeral = !plugin.getConfig().getBoolean("publicReplies.link", false);
            event.deferReply(ephemeral).queue();
            InteractionHook hook = event.getHook();
            hook.setEphemeral(true);
            String mcUsername = Objects.requireNonNull(event.getOption("minecraft_username")).getAsString();
            try {
                OptionMapping manualUseOffline = event.getOption("offline_mode");
                this.linkUser(Objects.requireNonNull(event.getMember()).getId(), mcUsername, manualUseOffline != null && manualUseOffline.getAsBoolean());
            }
            catch (IOException | SQLException e) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, plugin.getLanguage().getString("commandError")).queue();
                plugin.getLogger().severe("An error occurred while trying to link the user.\n" + e.getMessage());
                return;
            }
            catch (UserErrorException e) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, e.getMessage()).queue();
                return;
            }
            this.discordAgent.buildReply(hook, ReplyType.SUCCESS, plugin.getLanguage().getString("successLink")).queue();
        }));
        String verify = plugin.getConfig().getString("commandNames.verify", "verify");
        if (plugin.getConfig().getBoolean("requireVerification")) {
            this.commands.put(verify, new DiscordCommand(verify, plugin.getLanguage().getString("commandDescriptions.verify"), cmd -> cmd.setContexts(InteractionContextType.GUILD).addOption(OptionType.INTEGER, "verification_code", plugin.getLanguage().getString("commandArguments.verificationCode"), true), event -> {
                event.deferReply(true).queue();
                InteractionHook hook = event.getHook();
                hook.setEphemeral(true);
                Member member = Objects.requireNonNull(event.getMember());
                String discordId = member.getId();
                try {
                    int code = Objects.requireNonNull(event.getOption("verification_code")).getAsInt();
                    if (String.valueOf(code).length() != 6) {
                        throw new UserErrorException(String.format(plugin.getLanguage().getString("verification.wrongDigits"), 6));
                    }
                    DatabaseHandler.LinkedUserInfo userInfo = plugin.getDb().getLinkedUserInfo(discordId);
                    if (userInfo == null) {
                        throw new UserErrorException(plugin.getLanguage().getString("verification.notLinked").replace("$link_command_name$", link));
                    }
                    boolean success = plugin.getDb().verify(discordId, code);
                    if (!success) {
                        throw new UserErrorException(plugin.getLanguage().getString("verification.wrongCode"));
                    }
                    Guild guild = jda.getGuildById(plugin.getConfig().getString("bot.server"));
                    if (guild == null) {
                        plugin.getLogger().warning("Guild not found after verifying a user.");
                        return;
                    }
                    this.discordAgent.giveRoleAndNickname(member, userInfo.username, userInfo.uuid);
                    this.discordAgent.checkMemberRoles(member);
                }
                catch (SQLException e) {
                    this.discordAgent.buildReply(hook, ReplyType.ERROR, plugin.getLanguage().getString("commandError")).queue();
                    plugin.getLogger().severe("An error occurred while trying to verify the user.\n" + e.getMessage());
                    return;
                }
                catch (UserErrorException e) {
                    this.discordAgent.buildReply(hook, ReplyType.ERROR, e.getMessage()).queue();
                    return;
                }
                this.discordAgent.buildReply(hook, ReplyType.SUCCESS, plugin.getLanguage().getString("successVerify")).queue();
            }));
        }
        String unlink = plugin.getConfig().getString("commandNames.unlink", "unlink");
        this.commands.put(unlink, new DiscordCommand(unlink, plugin.getLanguage().getString("commandDescriptions.unlink"), cmd -> this.maybeAddOfflineModeArgument(cmd.setContexts(InteractionContextType.GUILD).setDefaultPermissions(DefaultMemberPermissions.enabledFor(Permission.MANAGE_ROLES)).addOption(OptionType.STRING, "minecraft_username", plugin.getLanguage().getString("commandArguments.minecraftUsername.unlink")).addOption(OptionType.USER, "discord_user", plugin.getLanguage().getString("commandArguments.discordUser.unlink"))), event -> {
            boolean ephemeral = !plugin.getConfig().getBoolean("publicReplies.unlink", false);
            event.deferReply(ephemeral).queue();
            InteractionHook hook = event.getHook();
            hook.setEphemeral(true);
            OptionMapping mcUser = event.getOption("minecraft_username");
            OptionMapping discordUser = event.getOption("discord_user");
            OptionMapping manualUseOffline = event.getOption("offline_mode");
            if (mcUser == null == (discordUser == null)) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, plugin.getLanguage().getString("incorrectCommandFormat")).queue();
                return;
            }
            try {
                DatabaseHandler.LinkedUserInfo userInfo = null;
                if (discordUser != null) {
                    userInfo = plugin.getDb().getLinkedUserInfo(discordUser.getAsUser().getId());
                } else {
                    UserSearchResult uuidSearch = this.userSearch.nameToUUID(mcUser.getAsString(), manualUseOffline != null && manualUseOffline.getAsBoolean());
                    if (uuidSearch != null) {
                        userInfo = plugin.getDb().getLinkedUserInfo(uuidSearch.uuid);
                    }
                }
                if (userInfo == null) {
                    throw new UserErrorException(plugin.getLanguage().getString("userNotLinked"));
                }
                this.discordAgent.setPermissions(userInfo.uuid, null);
                plugin.getDb().unlink(userInfo.uuid);
                Guild guild = jda.getGuildById(plugin.getConfig().getString("bot.server"));
                if (guild == null) {
                    plugin.getLogger().warning("Guild not found while trying to remove a linked role.");
                    return;
                }
                guild.retrieveMemberById(userInfo.discordId).queue(this.discordAgent::removeRoleAndNickname);
            }
            catch (IOException | SQLException e) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, plugin.getLanguage().getString("commandError")).queue();
                plugin.getLogger().severe("An error occurred while trying to unlink the user.\n" + e.getMessage());
                return;
            }
            catch (UserErrorException e) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, e.getMessage()).queue();
                return;
            }
            this.discordAgent.buildReply(hook, ReplyType.SUCCESS, plugin.getLanguage().getString("successUnlink")).queue();
        }));
        String info = plugin.getConfig().getString("commandNames.info", "info");
        this.commands.put(info, new DiscordCommand(info, plugin.getLanguage().getString("commandDescriptions.info"), cmd -> this.maybeAddOfflineModeArgument(cmd.setContexts(InteractionContextType.GUILD).setDefaultPermissions(DefaultMemberPermissions.enabledFor(Permission.MANAGE_ROLES)).addOption(OptionType.STRING, "minecraft_username", plugin.getLanguage().getString("commandArguments.minecraftUsername.info")).addOption(OptionType.USER, "discord_user", plugin.getLanguage().getString("commandArguments.discordUser.info"))), event -> {
            boolean ephemeral = !plugin.getConfig().getBoolean("publicReplies.info", false);
            event.deferReply(ephemeral).queue();
            InteractionHook hook = event.getHook();
            hook.setEphemeral(true);
            OptionMapping mcUser = event.getOption("minecraft_username");
            OptionMapping discordUser = event.getOption("discord_user");
            OptionMapping manualUseOffline = event.getOption("offline_mode");
            if (mcUser == null == (discordUser == null)) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, plugin.getLanguage().getString("incorrectCommandFormat")).queue();
                return;
            }
            try {
                DatabaseHandler.LinkedUserInfo userInfo = null;
                if (discordUser != null) {
                    userInfo = plugin.getDb().getLinkedUserInfo(discordUser.getAsUser().getId());
                } else {
                    UserSearchResult userSearchResult = this.userSearch.nameToUUID(mcUser.getAsString(), manualUseOffline != null && manualUseOffline.getAsBoolean());
                    if (userSearchResult != null) {
                        userInfo = plugin.getDb().getLinkedUserInfo(userSearchResult.uuid);
                    }
                }
                if (userInfo == null) {
                    throw new UserErrorException(plugin.getLanguage().getString("userNotLinked"));
                }
                String mcUserInfo = String.format("%s (`%s` - `%s`)", new Object[]{userInfo.username, userInfo.uuid, UUIDType.getTypeForUUID(userInfo.uuid)});
                jda.retrieveUserById(userInfo.discordId).queue(user -> {
                    String name = "_" + plugin.getLanguage().getString("unknownUser") + "_";
                    if (user != null) {
                        name = user.getAsMention();
                    }
                    this.discordAgent.buildReply(hook, plugin.getLanguage().getString("fullLinkedTo").replace("$discord_user$", name).replace("$minecraft_user$", mcUserInfo)).queue();
                });
            }
            catch (IOException | SQLException e) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, plugin.getLanguage().getString("commandError")).queue();
                plugin.getLogger().severe("An error occurred while trying to unlink the user.\n" + e.getMessage());
            }
            catch (UserErrorException e) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, e.getMessage()).queue();
            }
        }));
        String admlink = plugin.getConfig().getString("commandNames.admlink", "admlink");
        this.commands.put(admlink, new DiscordCommand(admlink, plugin.getLanguage().getString("commandDescriptions.admlink"), cmd -> this.maybeAddOfflineModeArgument(cmd.setContexts(InteractionContextType.GUILD).setDefaultPermissions(DefaultMemberPermissions.enabledFor(Permission.MANAGE_ROLES)).addOption(OptionType.STRING, "minecraft_username", plugin.getLanguage().getString("commandArguments.minecraftUsername.admlink"), true).addOption(OptionType.USER, "discord_user", plugin.getLanguage().getString("commandArguments.discordUser.admlink"), true)), event -> {
            boolean ephemeral = !plugin.getConfig().getBoolean("publicReplies.admlink", false);
            event.deferReply(ephemeral).queue();
            InteractionHook hook = event.getHook();
            hook.setEphemeral(true);
            String mcUser = Objects.requireNonNull(event.getOption("minecraft_username")).getAsString();
            User discordUser = Objects.requireNonNull(event.getOption("discord_user")).getAsUser();
            try {
                OptionMapping manualUseOffline = event.getOption("offline_mode");
                this.linkUser(discordUser.getId(), mcUser, manualUseOffline != null && manualUseOffline.getAsBoolean());
            }
            catch (IOException | SQLException e) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, plugin.getLanguage().getString("commandError")).queue();
                plugin.getLogger().severe("An error occurred while trying to link the user.\n" + e.getMessage());
                return;
            }
            catch (UserErrorException e) {
                this.discordAgent.buildReply(hook, ReplyType.ERROR, e.getMessage()).queue();
                return;
            }
            this.discordAgent.buildReply(hook, ReplyType.SUCCESS, plugin.getLanguage().getString("successLink")).queue();
        }));
    }

    private SlashCommandData maybeAddOfflineModeArgument(SlashCommandData cmd) {
        if (UUIDMode.fromCaseInsensitive(this.plugin.getConfig().getString("userUUIDMode")) == UUIDMode.MANUAL) {
            return cmd.addOption(OptionType.BOOLEAN, "offline_mode", this.plugin.getLanguage().getString("commandArguments.offlineMode"));
        }
        return cmd;
    }

    @Override
    public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent event) {
        if (event.getGuild() == null) {
            return;
        }
        String commandName = event.getName();
        DiscordCommand command = this.commands.get(commandName);
        if (command == null) {
            InteractionHook hook = event.getHook();
            hook.setEphemeral(true);
            this.discordAgent.buildReply(hook, "Unknown command " + commandName + ".").queue();
            return;
        }
        command.run(event);
    }

    public List<SlashCommandData> getCommandData() {
        ArrayList<SlashCommandData> commandData = new ArrayList<SlashCommandData>();
        for (DiscordCommand command : this.commands.values()) {
            commandData.add(command.getCommandData());
        }
        return commandData;
    }

    private void linkUser(String discordId, String mcUsername, boolean manualUseOffline) throws IOException, SQLException, UserErrorException {
        DatabaseHandler.LinkedUserInfo userInfo = this.plugin.getDb().getLinkedUserInfo(discordId);
        if (userInfo != null) {
            throw new UserErrorException(this.plugin.getLanguage().getString("discordAlreadyLinked"));
        }
        UserSearchResult result = this.userSearch.nameToUUID(mcUsername, manualUseOffline);
        if (result == null) {
            if (this.userSearch.isGeyser(mcUsername)) {
                throw new UserErrorException(this.plugin.getLanguage().getString("geyserUserNotFound"));
            }
            throw new UserErrorException(this.plugin.getLanguage().getString("minecraftUserNotFound"));
        }
        String uuid = result.uuid;
        userInfo = this.plugin.getDb().getLinkedUserInfo(uuid);
        if (userInfo != null) {
            throw new UserErrorException(this.plugin.getLanguage().getString("minecraftAlreadyLinked"));
        }
        this.plugin.getDb().linkUser(discordId, uuid);
        this.plugin.getDb().updateUsername(discordId, result.name);
        Objects.requireNonNull(this.jda.getGuildById(this.plugin.getConfig().getString("bot.server"))).retrieveMemberById(discordId).queue(member -> {
            if (member != null) {
                if (!this.plugin.getConfig().getBoolean("requireVerification")) {
                    this.discordAgent.giveRoleAndNickname((Member)member, result.name, uuid);
                }
                this.discordAgent.checkMemberRoles((Member)member);
            }
        });
    }
}

