/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigReader {
    public static FileConfiguration getConfigFromResource(String resourcePath) throws IOException {
        try (InputStream stream = ConfigReader.class.getResourceAsStream(ConfigReader.withLeadingSlash(resourcePath));){
            if (stream == null) {
                throw new FileNotFoundException("Resource " + resourcePath + " not found in classpath.");
            }
            YamlConfiguration config = new YamlConfiguration();
            try (InputStreamReader reader = new InputStreamReader(stream);){
                config.load((Reader)reader);
            }
            catch (InvalidConfigurationException e) {
                throw new IllegalArgumentException("Pattern resource " + resourcePath + " is not in the expected format.");
            }
            YamlConfiguration yamlConfiguration = config;
            return yamlConfiguration;
        }
    }

    private static String withLeadingSlash(String path) {
        return (path.charAt(0) == '/' ? "" : "/") + path;
    }
}

