/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.config.linter;

import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.config.linter.LintResult;
import dev.nicho.rolesync.config.linter.LintRule;
import dev.nicho.rolesync.minecraft.UUIDMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;

public class ConfigLinter {
    private static final String discordIdRegex = "^\\d{16,}$";
    private static final String placeholderAPIRegex = "%\\w+%";
    private final RoleSync plugin;
    private final LintRule[] lintRules = new LintRule[]{new LintRule("Requires config version", c -> {
        ArrayList<String> result = new ArrayList<String>();
        if (!c.isInt("configVersion")) {
            result.add("configVersion is set incorrectly. Please do not modify this field.");
        }
        return result;
    }), new LintRule("Validate bot essential config", c -> {
        String serverId;
        ArrayList<String> result = new ArrayList<String>();
        String token = c.getString("bot.token");
        if (token == null || token.isEmpty()) {
            result.add("Invalid or empty token set in 'bot.token'");
        }
        if (!this.isDiscordId(serverId = c.getString("bot.server"))) {
            result.add(String.format("'%s' is not a valid Discord ID for field bot.server", serverId));
            return result;
        }
        if (serverId.equals("000000000000000000")) {
            result.add("The bot.server value has not been modified from the default. Please set it in your config.yml.");
        }
        return result;
    }), new LintRule("Validate groups", c -> {
        ArrayList<String> result = new ArrayList<String>();
        ConfigurationSection groups2 = c.getConfigurationSection("groups");
        if (groups2 == null) {
            result.add("At least one group configuration is required in 'groups:'");
            return result;
        }
        Set keys = groups2.getKeys(true);
        if (keys.isEmpty()) {
            result.add("At least one group configuration is required in 'groups:'");
        }
        for (String group : keys) {
            List ids = groups2.getStringList(group);
            for (String id : ids) {
                if (this.isDiscordId(id)) continue;
                result.add(String.format("'%s' is not a valid Discord ID for field 'groups.%s'", id, group));
            }
        }
        return result;
    }), new LintRule("Validate database config", c -> {
        ArrayList<String> result = new ArrayList<String>();
        String dbType = c.getString("database.type");
        if (dbType.equalsIgnoreCase("mysql")) {
            if (c.getString("database.mysql.dbhost").isEmpty()) {
                result.add("You must configure `database.mysql` when using database type `mysql`.");
            }
            if (c.getBoolean("database.mysql.disableSSL")) {
                this.warn("WARNING! Using MySQL with SSL disabled. This is very unsafe. Traffic to the database is not encrypted.");
            }
        } else if (!dbType.equalsIgnoreCase("sqlite")) {
            result.add(String.format("Invalid database type '%s', must be mysql or sqlite", dbType));
        }
        return result;
    }), new LintRule("Validate whitelist config", c -> {
        ArrayList<String> result = new ArrayList<String>();
        if (!c.getBoolean("manageWhitelist")) {
            return result;
        }
        List roles = c.getStringList("whitelistRoles");
        if (roles == null || roles.isEmpty()) {
            result.add("whitelistRoles must not be empty when manageWhitelist is enabled");
            return result;
        }
        for (String role : roles) {
            if (this.isDiscordId(role)) continue;
            result.add(String.format("'%s' is not a valid Discord ID for field 'whitelistRoles'", role));
        }
        return result;
    }), new LintRule("Validate linked role config", c -> {
        ArrayList<String> result = new ArrayList<String>();
        if (!c.getBoolean("giveLinkedRole")) {
            return result;
        }
        String role = c.getString("linkedRole");
        if (role == null || role.isEmpty() || !role.matches(discordIdRegex)) {
            result.add(String.format("'%s' is not a valid Discord ID for field 'linkedRole'", role));
        }
        return result;
    }), new LintRule("Validate bot activity config", c -> {
        ArrayList<String> result = new ArrayList<String>();
        if (!c.getBoolean("botActivity.enable")) {
            return result;
        }
        String pattern = c.getString("botActivity.status");
        if (pattern == null || pattern.isEmpty()) {
            result.add("botActivity.status must not be empty when botActivity is enabled");
            return result;
        }
        if (pattern.matches(placeholderAPIRegex) && !c.getBoolean("integrations.plugins.PlaceholderAPI")) {
            result.add("botActivity.status contains a PlaceholderAPI placeholder, but the PlaceholderAPI integration is disabled. Please set integrations.plugins.PlaceholderAPI to true.");
        }
        return result;
    }), new LintRule("Validate discordRename", c -> {
        ArrayList<String> result = new ArrayList<String>();
        String pattern = c.getString("discordRename.template");
        if (pattern == null || pattern.isEmpty()) {
            return result;
        }
        if (pattern.matches(placeholderAPIRegex) && !c.getBoolean("integrations.plugins.PlaceholderAPI")) {
            result.add("discordRename.template contains a PlaceholderAPI placeholder, but the PlaceholderAPI integration is disabled. Please set integrations.plugins.PlaceholderAPI to true.");
        }
        return result;
    }), new LintRule("Validate embed config", c -> {
        ConfigurationSection colors;
        ArrayList<String> result = new ArrayList<String>();
        if (!c.getBoolean("embed.useEmbed")) {
            return result;
        }
        String pattern = c.getString("embed.title");
        if (pattern == null || pattern.isEmpty()) {
            result.add("embed.title must not be empty when embed.useEmbed is enabled");
        }
        if ((colors = c.getConfigurationSection("embed.colors")) == null) {
            result.add("embed.colors must not be empty when embed.useEmbed is enabled");
            return result;
        }
        Set keys = colors.getKeys(true);
        if (keys.isEmpty()) {
            result.add("embed.colors must not be empty when embed.useEmbed is enabled");
        }
        for (String key : keys) {
            String color = colors.getString(key);
            if (color.matches("^#[0-9A-Fa-f]{1,6}$")) continue;
            try {
                Class.forName("java.awt.Color").getField(color);
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                result.add(String.format("Color '%s' is not valid in field 'embed.colors.%s'", color, key));
            }
        }
        return result;
    }), new LintRule("Validate userUUIDMode", c -> {
        ArrayList<String> result = new ArrayList<String>();
        String mode = c.getString("userUUIDMode");
        try {
            UUIDMode.fromCaseInsensitive(mode);
        }
        catch (IllegalArgumentException e) {
            result.add(String.format("Value '%s' is not valid for property userUUIDMode. Please read the field's documentation for valid values.", mode));
        }
        return result;
    })};

    public ConfigLinter(RoleSync plugin) {
        this.plugin = plugin;
    }

    public ConfigLinter() {
        this(null);
    }

    public LintResult run(Configuration config) {
        LintResult results = new LintResult();
        for (LintRule rule : this.lintRules) {
            List<String> result = rule.run(config);
            if (result == null || result.isEmpty()) continue;
            results.add(rule.getName(), result);
        }
        return results;
    }

    private void warn(String msg) {
        if (this.plugin == null) {
            return;
        }
        this.plugin.getLogger().warning(msg);
    }

    private boolean isDiscordId(String id) {
        return id != null && !id.isEmpty() && id.matches(discordIdRegex);
    }
}

