/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.config.linter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LintResult {
    private final Map<String, List<String>> result = new HashMap<String, List<String>>();

    LintResult() {
    }

    void add(String ruleName, List<String> ruleResult) {
        this.result.put(ruleName, ruleResult);
    }

    public Map<String, List<String>> asMap() {
        return this.result;
    }

    public boolean isValid() {
        return this.result.isEmpty();
    }

    public String toString() {
        if (this.result.isEmpty()) {
            return "No config errors";
        }
        StringBuilder mainBuilder = new StringBuilder(String.format("%d config rule%s had errors.\n", this.result.size(), this.result.size() == 1 ? "" : "s"));
        for (String rule : this.result.keySet()) {
            StringBuilder builder = new StringBuilder().append(String.format("Config lint rule \"%s\" had errors:", rule));
            List<String> errors = this.result.get(rule);
            for (String err : errors) {
                builder.append("\n").append("\t- ").append(err);
            }
            builder.append("\n");
            mainBuilder.append("\n").append((CharSequence)builder);
        }
        return mainBuilder.toString();
    }
}

