/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.config.migrations;

import dev.nicho.rolesync.config.ConfigReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class ConfigMigration {
    private final int fromVersion;
    private final String resourcePath;
    private final Map<String, String> renamed = new HashMap<String, String>();
    private final Map<String, Object> hardcoded = new HashMap<String, Object>();
    private final Map<String, Function<Configuration, Object>> functions = new HashMap<String, Function<Configuration, Object>>();

    public ConfigMigration(int fromVersion, String resourcePath) {
        if (resourcePath.charAt(0) == '/') {
            throw new IllegalArgumentException("resourcePath may not start with a leading slash");
        }
        if (fromVersion < 0) {
            throw new IllegalArgumentException("Version cannot be negative");
        }
        this.fromVersion = fromVersion;
        this.resourcePath = resourcePath;
    }

    public ConfigMigration(String resourcePath) {
        this(0, resourcePath);
    }

    public int getFromVersion() {
        return this.fromVersion;
    }

    public void renamedKey(String previously, String name) {
        this.renamed.put(name, previously);
    }

    public void hardcode(String name, Object value) {
        this.hardcoded.put(name, value);
    }

    public void function(String name, Function<Configuration, Object> transformer) {
        this.functions.put(name, transformer);
    }

    public FileConfiguration run(FileConfiguration config) {
        return this.run(config.saveToString());
    }

    public FileConfiguration run(String config) {
        FileConfiguration oldConfig = this.parseFileConfiguration(config);
        FileConfiguration newConfig = this.createNewConfig();
        int version = newConfig.getInt("configVersion");
        oldConfig.getValues(true).forEach((k, v) -> {
            if (newConfig.contains(k, true) && !oldConfig.isConfigurationSection(k)) {
                newConfig.set(k, v);
            }
        });
        this.functions.forEach((newName, func) -> newConfig.set(newName, func.apply(oldConfig)));
        this.hardcoded.forEach((arg_0, arg_1) -> ((FileConfiguration)newConfig).set(arg_0, arg_1));
        this.renamed.forEach((name, previously) -> {
            if (oldConfig.contains(previously, true)) {
                newConfig.set(name, oldConfig.get(previously));
            }
        });
        newConfig.set("configVersion", (Object)version);
        return newConfig;
    }

    @NotNull
    private FileConfiguration parseFileConfiguration(String config) {
        int version;
        YamlConfiguration oldConfig = new YamlConfiguration();
        try {
            oldConfig.loadFromString(config);
        }
        catch (InvalidConfigurationException e) {
            throw new IllegalArgumentException("Invalid YAML supplied");
        }
        if (this.fromVersion != 0 && (version = oldConfig.getInt("configVersion", 1)) != this.fromVersion) {
            throw new IllegalArgumentException("This migration is not configured to accept config version " + version);
        }
        return oldConfig;
    }

    private FileConfiguration createNewConfig() {
        try {
            return ConfigReader.getConfigFromResource(this.resourcePath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting resource " + this.resourcePath + " from the .jar: " + e.getMessage());
        }
    }
}

