/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.db;

import dev.nicho.rolesync.RoleSync;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.bukkit.Bukkit;

public abstract class DatabaseHandler {
    protected final RoleSync plugin;
    protected final SecureRandom random;

    protected DatabaseHandler(RoleSync plugin) {
        this.plugin = plugin;
        this.random = new SecureRandom();
    }

    protected abstract Connection getConnection() throws SQLException;

    protected abstract void closeConnection(Connection var1) throws SQLException;

    protected void initialize() throws SQLException {
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers` (`discord_id` varchar(24) NOT NULL,`minecraft_uuid` varchar(36) NOT NULL,`whitelisted` boolean NOT NULL DEFAULT false,`verification_code` INT NOT NULL DEFAULT 0,`verified` boolean NOT NULL DEFAULT false,`username_when_linked` TEXT NULL,PRIMARY KEY (`discord_id`));");
        ps.execute();
        this.closeConnection(c);
    }

    public int getLinkedUserCount() throws SQLException {
        this.checkAsync();
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("SELECT COUNT(*) FROM " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers");
        ResultSet res = ps.executeQuery();
        int ret = 0;
        if (res.next()) {
            ret = res.getInt(1);
        }
        this.closeConnection(c);
        return ret;
    }

    public void linkUser(String discordID, String minecraftUUID) throws SQLException {
        this.checkAsync();
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("INSERT INTO " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers (discord_id, minecraft_uuid, verification_code) SELECT ?, ?, ? FROM (SELECT 1) as A WHERE NOT EXISTS(SELECT * FROM " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers WHERE minecraft_uuid = ?);");
        ps.setString(1, discordID);
        ps.setString(2, minecraftUUID);
        ps.setInt(3, this.random.nextInt(900000) + 100000);
        ps.setString(4, minecraftUUID);
        ps.execute();
        this.closeConnection(c);
    }

    public void updateUsername(String identifier, String minecraftUsername) throws SQLException {
        this.checkAsync();
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("UPDATE " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers SET username_when_linked = ? WHERE discord_id = ? OR minecraft_uuid = ?");
        ps.setString(1, minecraftUsername);
        ps.setString(2, identifier);
        ps.setString(3, identifier);
        ps.execute();
        this.closeConnection(c);
    }

    public void addToWhitelist(String uuid) throws SQLException {
        this.checkAsync();
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("UPDATE " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers SET whitelisted = 1 WHERE minecraft_uuid = ?");
        ps.setString(1, uuid);
        ps.execute();
        this.closeConnection(c);
    }

    public void removeFromWhitelist(String uuid) throws SQLException {
        this.checkAsync();
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("UPDATE " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers SET whitelisted = 0 WHERE minecraft_uuid = ?");
        ps.setString(1, uuid);
        ps.execute();
        this.closeConnection(c);
    }

    public void unlink(String uuid) throws SQLException {
        this.checkAsync();
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("DELETE FROM " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers WHERE minecraft_uuid = ?");
        ps.setString(1, uuid);
        ps.execute();
        this.closeConnection(c);
        this.removeFromWhitelist(uuid);
    }

    public void forAllLinkedUsers(Consumer<LinkedUserInfo> callback) throws SQLException {
        this.checkAsync();
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("SELECT discord_id, minecraft_uuid, whitelisted, verification_code, verified, username_when_linked FROM " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            callback.accept(new LinkedUserInfo(rs.getString(1), rs.getString(2), rs.getBoolean(3), rs.getBoolean(5), rs.getInt(4), rs.getString(6)));
        }
        this.closeConnection(c);
    }

    public LinkedUserInfo getLinkedUserInfo(String identifier) throws SQLException {
        this.checkAsync();
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("SELECT discord_id, minecraft_uuid, whitelisted, verification_code, verified, username_when_linked FROM " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers WHERE discord_id = ? OR minecraft_uuid = ?");
        ps.setString(1, identifier);
        ps.setString(2, identifier);
        ResultSet res = ps.executeQuery();
        LinkedUserInfo ret = null;
        if (res.next()) {
            int verificationCode = res.getInt(4);
            if (verificationCode != 0) {
                ret = new LinkedUserInfo(res.getString(1), res.getString(2), res.getBoolean(3), res.getBoolean(5), verificationCode, res.getString(6));
            } else {
                verificationCode = this.random.nextInt(900000) + 100000;
                ret = new LinkedUserInfo(res.getString(1), res.getString(2), res.getBoolean(3), false, verificationCode, res.getString(6));
                ps.close();
                ps = c.prepareStatement("UPDATE " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers SET verification_code = ? WHERE discord_id = ? OR minecraft_uuid = ?");
                ps.setInt(1, verificationCode);
                ps.setString(2, identifier);
                ps.setString(3, identifier);
                ps.execute();
            }
        }
        this.closeConnection(c);
        return ret;
    }

    public boolean verify(String identifier, int verificationCode) throws SQLException {
        LinkedUserInfo userInfo = this.getLinkedUserInfo(identifier);
        if (userInfo == null) {
            return false;
        }
        if (userInfo.code != verificationCode) {
            return false;
        }
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("UPDATE " + this.plugin.getConfig().getString("database.tablePrefix") + "_discordmcusers SET verified = ? WHERE discord_id = ? OR minecraft_uuid = ?");
        ps.setBoolean(1, true);
        ps.setString(2, identifier);
        ps.setString(3, identifier);
        ps.execute();
        this.closeConnection(c);
        return true;
    }

    private void checkAsync() {
        if (Bukkit.isPrimaryThread()) {
            this.plugin.debugLog("Database operation called from main Bukkit thread.", new Object[0]);
        }
    }

    public static class LinkedUserInfo {
        public final int code;
        public final boolean verified;
        public final boolean whitelisted;
        public final String discordId;
        public final String uuid;
        public final String username;

        LinkedUserInfo(String discordId, String uuid, boolean whitelisted, boolean verified, int code, String username) {
            this.code = code;
            this.verified = verified;
            this.whitelisted = whitelisted;
            this.discordId = discordId;
            this.uuid = uuid;
            this.username = username;
        }
    }
}

