/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.db;

import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.db.DatabaseHandler;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SQLiteHandler
extends DatabaseHandler {
    private final File db;
    private Connection connection;

    public SQLiteHandler(RoleSync plugin, File db) throws IOException, SQLException {
        super(plugin);
        if (!db.exists() && !db.createNewFile()) {
            throw new IllegalStateException("Unable to create new SQLite database.");
        }
        this.db = db;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load SQLite JBDC driver. If SQLite is not bundled with your server, you may need to manually add these libraries. Please report this to the developer.\n" + e.getMessage());
        }
        this.initialize();
    }

    @Override
    protected Connection getConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection;
        }
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.db);
        return this.connection;
    }

    @Override
    protected void closeConnection(Connection c) {
    }
}

