/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.integrations.placeholders;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.db.DatabaseHandler;
import dev.nicho.rolesync.integrations.placeholders.PlaceholderCacheKey;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoleSyncPlaceholderExpansion
extends PlaceholderExpansion {
    private final RoleSync plugin;
    private final LoadingCache<PlaceholderCacheKey, Optional<String>> cache;

    public RoleSyncPlaceholderExpansion(RoleSync plugin) {
        this.plugin = plugin;
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<PlaceholderCacheKey, Optional<String>>(){

            @NotNull
            public Optional<String> load(@NotNull PlaceholderCacheKey key) {
                return Optional.ofNullable(RoleSyncPlaceholderExpansion.this.uncachedRequest(key.player, key.placeholder));
            }
        });
    }

    @NotNull
    public String getAuthor() {
        List authorList = this.plugin.getDescription().getAuthors();
        if (authorList.isEmpty()) {
            return "";
        }
        return (String)authorList.get(0);
    }

    @NotNull
    public String getIdentifier() {
        return "drs";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Nullable
    public String onRequest(@Nullable OfflinePlayer player, @NotNull String params) {
        try {
            OfflinePlayer playerKey = this.isPlayerAgnostic(params) ? null : player;
            return ((Optional)this.cache.get((Object)new PlaceholderCacheKey(playerKey, params))).orElse(null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isPlayerAgnostic(String placeholder) {
        return placeholder.equals("linked_users");
    }

    @Nullable
    public String uncachedRequest(@Nullable OfflinePlayer player, @NotNull String params) {
        this.plugin.debugLog(String.format("Received uncached PlaceholderAPI request. main_thread=%s params=%s player=%s", Bukkit.isPrimaryThread(), params, player), new Object[0]);
        if (player == null && !this.isPlayerAgnostic(params)) {
            return null;
        }
        try {
            switch (params.toLowerCase(Locale.ENGLISH)) {
                case "linked_users": {
                    return this.placeholderLinkedUsers();
                }
                case "link_status": {
                    assert (player != null);
                    return this.placeholderPlayerLinkStatus(player);
                }
                case "discord_username": {
                    assert (player != null);
                    return this.placeholderPlayerDiscordUsername(player);
                }
                case "discord_display_name": {
                    assert (player != null);
                    return this.placeholderPlayerDiscordDisplayName(player);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning(String.format("Error while computing placeholder %s for player %s", params, player));
        }
        return null;
    }

    private String placeholderLinkedUsers() throws SQLException {
        return String.valueOf(this.plugin.getDb().getLinkedUserCount());
    }

    private String placeholderPlayerLinkStatus(@NotNull OfflinePlayer player) throws SQLException {
        boolean linked = this.plugin.getDb().getLinkedUserInfo(player.getUniqueId().toString()) != null;
        return linked ? this.plugin.getLanguage().getString("linkStatus.linked") : this.plugin.getLanguage().getString("linkStatus.notLinked");
    }

    private String placeholderPlayerDiscordUsername(@NotNull OfflinePlayer player) throws SQLException {
        DatabaseHandler.LinkedUserInfo userInfo = this.plugin.getDb().getLinkedUserInfo(player.getUniqueId().toString());
        if (userInfo == null) {
            return "";
        }
        String username = this.plugin.getBot().getDiscordUsername(userInfo.discordId);
        if (username == null) {
            return "";
        }
        return username;
    }

    private String placeholderPlayerDiscordDisplayName(@NotNull OfflinePlayer player) throws SQLException {
        DatabaseHandler.LinkedUserInfo userInfo = this.plugin.getDb().getLinkedUserInfo(player.getUniqueId().toString());
        if (userInfo == null) {
            return "";
        }
        String nick = this.plugin.getBot().getDiscordDisplayName(userInfo.discordId);
        if (nick == null) {
            return "";
        }
        return nick;
    }
}

