/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.listeners;

import DiscordRoleSync.net.dv8tion.jda.api.entities.Guild;
import DiscordRoleSync.net.dv8tion.jda.api.entities.Member;
import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.db.DatabaseHandler;
import dev.nicho.rolesync.util.plugin_meta.PluginVersion;
import java.io.IOException;
import java.sql.SQLException;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoinListener
implements Listener {
    private final RoleSync plugin;
    private final String chatPrefix;

    public PlayerJoinListener(RoleSync plugin) {
        this.plugin = plugin;
        this.chatPrefix = plugin.getConfig().getString("chatPrefix.text", "[DRS]") + " ";
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String uuid = player.getUniqueId().toString();
        String username = player.getName();
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                DatabaseHandler.LinkedUserInfo usrInfo = this.plugin.getDb().getLinkedUserInfo(uuid);
                if (usrInfo != null) {
                    if (!username.equals(usrInfo.username)) {
                        this.plugin.getLogger().info(String.format("User with UUID %s has changed names from '%s' to '%s', updating in the database...", uuid, usrInfo.username, username));
                        this.plugin.getDb().updateUsername(uuid, username);
                    }
                    if (this.plugin.getConfig().getBoolean("requireVerification") && !usrInfo.verified) {
                        return;
                    }
                    Guild guild = this.plugin.getBot().getJDA().getGuildById(this.plugin.getConfig().getString("bot.server"));
                    if (guild != null) {
                        guild.retrieveMemberById(usrInfo.discordId).queue(member -> {
                            if (member == null) {
                                return;
                            }
                            this.plugin.getBot().getAgent().giveRoleAndNickname((Member)member, username, uuid);
                        });
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error while checking/updating newly joined user's username.\n" + e.getMessage());
            }
        });
        if (player.hasPermission("discordrolesync.notifyupdates")) {
            String installedVersion = this.plugin.getDescription().getVersion();
            PluginVersion.VersionType versionType = PluginVersion.getVersionType(installedVersion);
            if (versionType != PluginVersion.VersionType.RELEASE) {
                String message = ChatColor.BLUE + this.chatPrefix + ChatColor.RED + this.plugin.getLanguage().getString("nonReleaseVersion.running." + versionType.toString());
                event.getPlayer().sendMessage(message);
                return;
            }
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                String latestVersion;
                boolean isOldVersion;
                PluginVersion v = new PluginVersion(this.plugin);
                try {
                    isOldVersion = v.isOldRelease(installedVersion);
                    latestVersion = v.getLatestVersion();
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Error while checking for latest version." + e.getMessage());
                    return;
                }
                if (isOldVersion) {
                    String message = ChatColor.BLUE + this.chatPrefix + ChatColor.AQUA + this.plugin.getLanguage().getString("notLatestVersion") + "\n" + ChatColor.BLUE + this.chatPrefix + ChatColor.AQUA + this.plugin.getLanguage().getString("current") + " " + ChatColor.RED + installedVersion + ChatColor.AQUA + "\n" + ChatColor.BLUE + this.chatPrefix + ChatColor.AQUA + this.plugin.getLanguage().getString("latest") + " " + ChatColor.GREEN + latestVersion;
                    event.getPlayer().sendMessage(message);
                }
            });
        }
    }
}

