/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.listeners;

import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.db.DatabaseHandler;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.jetbrains.annotations.NotNull;

public class WhitelistLoginListener
implements Listener {
    private final RoleSync plugin;

    public WhitelistLoginListener(RoleSync plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerLogin(@NotNull AsyncPlayerPreLoginEvent event) {
        DatabaseHandler.LinkedUserInfo usrInfo;
        this.plugin.debugLog("Player %s (%s) is attempting to login.", event.getName(), event.getUniqueId());
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)event.getUniqueId());
        if (player != null && this.plugin.getVault().hasPermission(player, "discordrolesync.bypasswhitelist")) {
            this.plugin.getLogger().info(String.format("Player %s (%s) has bypass whitelist permission, allowing login.", event.getName(), event.getUniqueId()));
            return;
        }
        try {
            usrInfo = this.plugin.getDb().getLinkedUserInfo(event.getUniqueId().toString());
        }
        catch (SQLException e) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, this.plugin.getLanguage().getString("whitelistErrorKickMsg"));
            this.plugin.getLogger().severe("Error while checking if a user is whitelisted.\n" + e.getMessage());
            return;
        }
        if (usrInfo == null) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, this.plugin.getLanguage().getString("pleaseLink") + " " + this.plugin.getConfig().getString("discordUrl"));
        } else if (this.plugin.getConfig().getBoolean("requireVerification") && !usrInfo.verified) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, this.plugin.getLanguage().getString("verification.instructions").replace("$verify_command_name$", this.plugin.getConfig().getString("commandNames.verify", "verify")).replace("$verification_code$", ChatColor.AQUA + String.valueOf(usrInfo.code) + ChatColor.RESET));
        } else if (!usrInfo.whitelisted) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, this.plugin.getLanguage().getString("notWhitelistedKickMsg"));
        }
    }
}

