/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.minecraft;

import dev.nicho.rolesync.minecraft.UserSearch;
import dev.nicho.rolesync.minecraft.UserSearchResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONObject;

public class MojangAPI {
    private final JavaPlugin plugin;

    public MojangAPI(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    protected URL getMojangApiUrl() {
        String[] servers;
        String alternateServer = this.plugin.getConfig().getString("alternativeServer");
        for (String server : servers = new String[]{alternateServer, "https://api.mojang.com"}) {
            if (server == null || server.isEmpty()) continue;
            try {
                return new URI(server).toURL();
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                this.plugin.getLogger().warning(String.format("Unable to use server '%s'. URL cannot be parsed.", server));
            }
        }
        return null;
    }

    public UserSearchResult searchName(String name) throws IOException {
        JSONObject body;
        URL reqUrl = new URL(this.getMojangApiUrl(), "users/profiles/minecraft/" + name);
        HttpURLConnection c = (HttpURLConnection)reqUrl.openConnection();
        c.setRequestMethod("GET");
        c.connect();
        int responseCode = c.getResponseCode();
        if (responseCode == 404) {
            return null;
        }
        if (responseCode != 200) {
            throw new IOException(String.format("Error contacting Mojang API (HTTP %s): %s", responseCode, c.getResponseMessage()));
        }
        try (InputStream response = c.getInputStream();
             Scanner scanner = new Scanner(response);){
            body = new JSONObject(scanner.useDelimiter("\\A").next());
        }
        return new UserSearchResult(body.getString("name"), UserSearch.uuidAddDashes(body.getString("id")));
    }
}

