/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.minecraft;

import dev.nicho.rolesync.RoleSync;
import dev.nicho.rolesync.minecraft.MojangAPI;
import dev.nicho.rolesync.minecraft.UUIDMode;
import dev.nicho.rolesync.minecraft.UserSearchResult;
import dev.nicho.rolesync.minecraft.XboxAPI;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Nullable;

public class UserSearch {
    private final RoleSync plugin;
    private final MojangAPI mojangAPI;
    private final XboxAPI xboxAPI;

    public UserSearch(RoleSync plugin) {
        this.plugin = plugin;
        this.mojangAPI = new MojangAPI(plugin);
        this.xboxAPI = new XboxAPI();
    }

    public boolean isGeyser(String name) {
        return name.startsWith(".") && this.plugin.getConfig().getBoolean("experimental.geyser.enableGeyserSupport", false);
    }

    @Nullable
    public UserSearchResult nameToUUID(String name, boolean manualOffline) throws IOException {
        if (this.isGeyser(name)) {
            return this.xboxAPI.searchName(name);
        }
        UUIDMode mode = UUIDMode.fromCaseInsensitive(this.plugin.getConfig().getString("userUUIDMode"));
        boolean useOnline = false;
        if (mode == UUIDMode.DEFAULT) {
            useOnline = Bukkit.getOnlineMode();
        } else if (mode == UUIDMode.ONLINE) {
            useOnline = true;
        } else if (mode == UUIDMode.MANUAL) {
            boolean bl = useOnline = !manualOffline;
        }
        if (useOnline || mode == UUIDMode.FALLBACK) {
            UserSearchResult onlineResult = this.mojangAPI.searchName(name);
            if (useOnline || onlineResult != null) {
                return onlineResult;
            }
        }
        return new UserSearchResult(name, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)).toString());
    }

    static String uuidAddDashes(String uuid) {
        return UUID.fromString(uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5")).toString();
    }
}

