/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.minecraft;

import dev.nicho.rolesync.minecraft.UserSearch;
import dev.nicho.rolesync.minecraft.UserSearchResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import org.json.JSONObject;

public class XboxAPI {
    public UserSearchResult searchName(String name) throws IOException {
        URL reqUrl;
        try {
            String xboxName = name.replace("_", "%20").replace(".", "");
            reqUrl = new URI("https://api.geysermc.org/v2/xbox/xuid/" + xboxName).toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException("Incorrectly formatted name");
        }
        HttpURLConnection c = (HttpURLConnection)reqUrl.openConnection();
        c.setRequestMethod("GET");
        c.connect();
        int responseCode = c.getResponseCode();
        if (this.isNotFound(c)) {
            return null;
        }
        if (responseCode != 200) {
            throw new IOException(String.format("Error contacting GeyserMC API (HTTP %s): %s", responseCode, c.getResponseMessage()));
        }
        JSONObject body = this.getJSONBody(c);
        String uuid = String.format("%032X", body.getLong("xuid"));
        return new UserSearchResult(name, UserSearch.uuidAddDashes(uuid));
    }

    private boolean isNotFound(HttpURLConnection c) throws IOException {
        if (c.getResponseCode() == 404) {
            return true;
        }
        return c.getResponseCode() == 503 && this.getJSONBody(c).getString("message").contains("Unable to find user in our cache");
    }

    private JSONObject getJSONBody(HttpURLConnection c) throws IOException {
        try (InputStream response = this.getErrorOrInputStream(c);){
            Scanner scanner = new Scanner(response);
            try {
                JSONObject jSONObject = new JSONObject(scanner.useDelimiter("\\A").next());
                scanner.close();
                return jSONObject;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private InputStream getErrorOrInputStream(HttpURLConnection c) throws IOException {
        if (c.getResponseCode() < 400) {
            return c.getInputStream();
        }
        return c.getErrorStream();
    }
}

