/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.util.caching;

import java.util.concurrent.Callable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class MetricCacher<T> {
    private final long interval;
    private final JavaPlugin plugin;
    private final Callable<T> callable;
    private T value;
    private BukkitTask task;

    public MetricCacher(JavaPlugin plugin, Callable<T> callable, long interval) {
        this.interval = interval;
        this.plugin = plugin;
        this.callable = callable;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() {
        MetricCacher metricCacher = this;
        synchronized (metricCacher) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        MetricCacher metricCacher = this;
        synchronized (metricCacher) {
            if (this.task != null) {
                return;
            }
            Runnable run = () -> {
                MetricCacher metricCacher = this;
                synchronized (metricCacher) {
                    try {
                        this.value = this.callable.call();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.task = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, run, 0L, this.interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MetricCacher metricCacher = this;
        synchronized (metricCacher) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

