/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.util.plugin_meta;

import dev.nicho.rolesync.RoleSync;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.TestOnly;
import org.json.JSONArray;
import org.json.JSONObject;

public class PluginVersion {
    private String latestVersion;
    private final RoleSync plugin;

    public PluginVersion() {
        this(null);
    }

    public PluginVersion(RoleSync plugin) {
        this.plugin = plugin;
    }

    public String getLatestVersion() throws IOException {
        if (this.latestVersion == null) {
            this.refreshLatestVersion();
        }
        if (this.plugin != null) {
            this.plugin.debugLog("getLatestVersion: %s", this.latestVersion);
        }
        return this.latestVersion;
    }

    @TestOnly
    protected void setLatestVersion(String version) {
        this.latestVersion = version;
    }

    public void refreshLatestVersion() throws IOException {
        JSONArray body;
        URL reqUrl = new URL("https://api.modrinth.com/v2/project/discordrolesync/version");
        HttpURLConnection c = (HttpURLConnection)reqUrl.openConnection();
        c.setRequestMethod("GET");
        c.connect();
        if (c.getResponseCode() != 200) {
            throw new IOException("Error getting latest version from Modrinth.");
        }
        try (InputStream response = c.getInputStream();
             Scanner scanner = new Scanner(response);){
            body = new JSONArray(scanner.useDelimiter("\\A").next());
        }
        if (body.isEmpty()) {
            throw new IOException("No versions found on Modrinth.");
        }
        JSONObject latestVersion = body.getJSONObject(0);
        this.latestVersion = latestVersion.getString("version_number");
        if (this.plugin != null) {
            this.plugin.debugLog("refreshed latest version: %s", this.latestVersion);
        }
    }

    public static VersionType getVersionType(String version) {
        Pattern release = Pattern.compile("^\\d+\\.\\d+\\.\\d+$");
        if (release.matcher(version).find()) {
            return VersionType.RELEASE;
        }
        Pattern releaseCandidate = Pattern.compile("^\\d+\\.\\d+\\.\\d+-.+$");
        if (releaseCandidate.matcher(version).find()) {
            return VersionType.RELEASE_CANDIDATE;
        }
        Pattern devPreview = Pattern.compile("^master-.+$");
        if (devPreview.matcher(version).find()) {
            return VersionType.DEVELOPMENT_PREVIEW;
        }
        return VersionType.UNKNOWN;
    }

    public boolean isOldRelease(String version) throws IOException {
        SemanticVersion latest;
        SemanticVersion current;
        try {
            current = PluginVersion.parseSemanticVersion(version);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        try {
            String latestRaw = this.getLatestVersion();
            if (PluginVersion.getVersionType(latestRaw) != VersionType.RELEASE) {
                return false;
            }
            latest = PluginVersion.parseSemanticVersion(latestRaw);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (latest.major > current.major) {
            return true;
        }
        if (latest.major < current.major) {
            return false;
        }
        if (latest.minor > current.minor) {
            return true;
        }
        if (latest.minor < current.minor) {
            return false;
        }
        return latest.patch > current.patch;
    }

    protected static SemanticVersion parseSemanticVersion(String version) throws IllegalArgumentException {
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-(.+))?$");
        Matcher matcher = pattern.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Must be a semantic version formatted string.");
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        return new SemanticVersion(major, minor, patch, matcher.group(4));
    }

    public static enum VersionType {
        UNKNOWN,
        DEVELOPMENT_PREVIEW,
        RELEASE_CANDIDATE,
        RELEASE;

    }

    protected static class SemanticVersion {
        public final int major;
        public final int minor;
        public final int patch;
        public final String additional;

        public SemanticVersion(int major, int minor, int patch, String additional) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.additional = additional;
        }
    }
}

