/*
 * Decompiled with CFR 0.152.
 */
package dev.nicho.rolesync.util.vault;

import dev.nicho.rolesync.RoleSync;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class VaultAPI {
    private final Permission permProvider;
    private final RoleSync plugin;

    public VaultAPI(RoleSync plugin, Permission permProvider) throws IllegalStateException {
        this.permProvider = permProvider;
        this.plugin = plugin;
    }

    public void setGroups(String uuid, @Nullable List<String> groups2) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
        for (String managedPerm : this.getManagedGroups()) {
            if (groups2 != null && groups2.contains(managedPerm)) continue;
            this.removeGroup(player, managedPerm);
        }
        if (groups2 != null) {
            groups2.forEach(group -> this.addGroup(player, (String)group));
        }
    }

    private void addGroup(OfflinePlayer player, String group) {
        this.plugin.debugLog("Adding group %s to player %s", group, player.getName());
        this.permProvider.playerAddGroup(null, player, group);
    }

    private void removeGroup(OfflinePlayer player, String group) {
        if (this.permProvider.playerInGroup(null, player, group)) {
            this.plugin.debugLog("Removing group %s from player %s", group, player.getName());
            this.permProvider.playerRemoveGroup(null, player, group);
        }
    }

    public boolean hasPermission(OfflinePlayer player, String permission) {
        return this.permProvider.playerHas(null, player, permission);
    }

    public String getPermPluginName() {
        return this.permProvider.getName();
    }

    protected List<String> getManagedGroups() {
        ConfigurationSection perms = this.plugin.getConfig().getConfigurationSection("groups");
        ArrayList<String> managedGroups = new ArrayList<String>();
        for (String perm : perms.getKeys(true)) {
            if (perms.getStringList(perm).isEmpty()) continue;
            managedGroups.add(perm);
        }
        return managedGroups;
    }
}

