package com.illusivesoulworks.cakechomps.mixin.core;

import com.illusivesoulworks.cakechomps.mixin.CakePipeline;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_636.class)
public abstract class MixinMultiPlayerGameMode {

  @Unique
  @Final
  CakePipeline cakechomps$cakePipeline = new CakePipeline();

  @Inject(
      at = @At("HEAD"),
      method = "performUseItemOn(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"
  )
  private void cakechomps$useItemOn(class_746 player, class_1268 hand, class_3965 result,
                                    CallbackInfoReturnable<class_1269> cir) {
    this.cakechomps$cakePipeline.init(player.method_37908(), result);
  }

  @Inject(
      at = @At("RETURN"),
      method = "performUseItemOn(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"
  )
  private void cakechomps$useItemOnReturn(class_746 player, class_1268 hand,
                                          class_3965 result,
                                          CallbackInfoReturnable<class_1269> cir) {
    this.cakechomps$cakePipeline.runCheck(player, player.method_37908(), result);
  }
}
