/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.cakechomps.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CakePipeline {
    private int lastBiteLevel = -1;
    private ItemStack refStack = ItemStack.EMPTY;

    public void init(Level level, BlockHitResult blockHitResult) {
        BlockPos pos = blockHitResult.getBlockPos();
        BlockState state = level.getBlockState(pos);
        state.getOptionalValue((Property)CakeBlock.BITES).ifPresent(val -> {
            this.lastBiteLevel = val;
            this.refStack = state.getCloneItemStack((LevelReader)level, pos, false);
        });
    }

    public void runCheck(Player player, Level level, BlockHitResult blockHitResult) {
        Consumable consumable;
        ItemStack blockStack;
        BlockPos pos;
        BlockState state;
        boolean flag;
        if (this.lastBiteLevel >= 0 && (flag = (state = level.getBlockState(pos = blockHitResult.getBlockPos())).getOptionalValue((Property)CakeBlock.BITES).map(val -> val > this.lastBiteLevel).orElse(true).booleanValue()) && !(blockStack = this.refStack).isEmpty() && (consumable = (Consumable)blockStack.getOrDefault(DataComponents.CONSUMABLE, (Object)Consumables.DEFAULT_FOOD)).shouldEmitParticlesAndSounds(0)) {
            consumable.emitParticlesAndSounds(player.getRandom(), (LivingEntity)player, blockStack, 5);
        }
        this.lastBiteLevel = -1;
    }
}

