/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers;

import com.benbenlaw.routers.block.RoutersBlocks;
import com.benbenlaw.routers.block.entity.RoutersBlockEntities;
import com.benbenlaw.routers.config.StartupConfig;
import com.benbenlaw.routers.item.RoutersCreativeTab;
import com.benbenlaw.routers.item.RoutersDataComponents;
import com.benbenlaw.routers.item.RoutersItems;
import com.benbenlaw.routers.networking.RoutersNetworking;
import com.benbenlaw.routers.particle.RoutersParticles;
import com.benbenlaw.routers.screen.ConfigScreen;
import com.benbenlaw.routers.screen.ExporterScreen;
import com.benbenlaw.routers.screen.ImporterScreen;
import com.benbenlaw.routers.screen.RoutersMenuTypes;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="routers")
public class Routers {
    public static final String MOD_ID = "routers";
    public static final Logger LOGGER = LogManager.getLogger();

    public Routers(IEventBus eventBus, ModContainer modContainer) {
        RoutersItems.ITEMS.register(eventBus);
        RoutersDataComponents.COMPONENTS.register(eventBus);
        RoutersBlocks.BLOCKS.register(eventBus);
        RoutersBlockEntities.BLOCK_ENTITIES.register(eventBus);
        RoutersMenuTypes.MENUS.register(eventBus);
        RoutersCreativeTab.CREATIVE_MODE_TABS.register(eventBus);
        RoutersParticles.PARTICLE_TYPES.register(eventBus);
        eventBus.addListener(this::commonSetup);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)StartupConfig.SPEC, "bbl/routers-startup.toml");
    }

    public void commonSetup(RegisterPayloadHandlersEvent event) {
        RoutersNetworking.registerNetworking(event);
    }

    @EventBusSubscriber(modid="routers", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)RoutersMenuTypes.EXPORTER_MENU.get(), ExporterScreen::new);
            event.register((MenuType)RoutersMenuTypes.IMPORTER_MENU.get(), ImporterScreen::new);
            event.register((MenuType)RoutersMenuTypes.CONFIG_MENU.get(), ConfigScreen::new);
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        }
    }
}

