/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.data;

import com.benbenlaw.routers.data.RoutersBlockTagsProvider;
import com.benbenlaw.routers.data.RoutersItemModelsProvider;
import com.benbenlaw.routers.data.RoutersItemTagsProvider;
import com.benbenlaw.routers.data.RoutersLangProvider;
import com.benbenlaw.routers.data.RoutersLootTableProvider;
import com.benbenlaw.routers.data.RoutersRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="routers")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new RoutersRecipeProvider(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(RoutersLootTableProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        RoutersBlockTagsProvider blockTags = new RoutersBlockTagsProvider(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        RoutersItemTagsProvider itemTags = new RoutersItemTagsProvider(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new RoutersItemModelsProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new RoutersLangProvider(packOutput, event.getExistingFileHelper()));
    }
}

