/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.item;

import com.benbenlaw.routers.screen.ConfigMenu;
import com.benbenlaw.routers.util.RoutersTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class UpgradeItem
extends Item {
    private final int extractValuePerOperation;

    public UpgradeItem(Item.Properties properties, int extractValuePerOperation) {
        super(properties);
        this.extractValuePerOperation = extractValuePerOperation;
    }

    public int getExtractAmount() {
        return this.extractValuePerOperation;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            if (stack.is(RoutersTags.Items.RF_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.rf_upgrade", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.ITEM_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.item_upgrade", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.FLUID_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.fluid_upgrade", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.CHEMICAL_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.chemical_upgrade", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.SPEED_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.speed_upgrade", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.SOURCE_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.source_upgrade", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.round_robin_upgrade", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.SOUL_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.soul_upgrade", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.PRESSURE_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.pressure_upgrade", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.HEAT_UPGRADES_PC)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.heat_upgrade_pc", (Object[])new Object[]{this.extractValuePerOperation}).withStyle(ChatFormatting.YELLOW));
            }
            if (stack.is(RoutersTags.Items.DIMENSIONAL_UPGRADES)) {
                components.add((Component)Component.translatable((String)"tooltip.routers.dimensional_upgrade").withStyle(ChatFormatting.YELLOW));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltip.routers.hold_shift").withStyle(ChatFormatting.YELLOW));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(RoutersTags.Items.FILTERS)) {
            BlockPos pos = player.blockPosition();
            SimpleContainerData data = new SimpleContainerData(2);
            player.openMenu((MenuProvider)new SimpleMenuProvider((arg_0, arg_1, arg_2) -> UpgradeItem.lambda$use$0(pos, (ContainerData)data, arg_0, arg_1, arg_2), (Component)Component.translatable((String)"screen.routers.config_screen")), buf -> buf.writeBlockPos(pos));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    private static /* synthetic */ AbstractContainerMenu lambda$use$0(BlockPos pos, ContainerData data, int windowId, Inventory playerInventory, Player playerEntity) {
        return new ConfigMenu(windowId, playerInventory, pos, data);
    }
}

