/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.screen;

import com.benbenlaw.routers.screen.ExporterMenu;
import com.benbenlaw.routers.screen.util.GhostSlot;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class ExporterScreen
extends AbstractContainerScreen<ExporterMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"routers", (String)"textures/gui/exporter_gui.png");

    public ExporterScreen(ExporterMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageHeight = 172;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        for (Slot slot : ((ExporterMenu)this.menu).slots) {
            Object chemicalObj;
            if (!(slot instanceof GhostSlot)) continue;
            GhostSlot ghostSlot = (GhostSlot)slot;
            if (ghostSlot.hasFluid()) {
                FluidStack fluid = ghostSlot.getGhostFluid();
                if (!fluid.isEmpty()) {
                    this.renderFluidStack(guiGraphics, fluid, x + slot.x, y + slot.y, 16, 16);
                } else {
                    guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"empty"), mouseX, mouseY);
                }
            }
            if (!ModList.get().isLoaded("mekanism") || !ghostSlot.hasChemical() || (chemicalObj = ghostSlot.getGhostChemical()) == null) continue;
            ChemicalStack stack = (ChemicalStack)chemicalObj;
            if (!stack.isEmpty()) {
                this.renderChemicalStack(guiGraphics, stack, x + slot.x, y + slot.y, 16, 16);
                continue;
            }
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"empty"), mouseX, mouseY);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void renderFluidStack(GuiGraphics guiGraphics, FluidStack fluid, int x, int y, int width, int height) {
        if (fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        ResourceLocation texture = extensions.getStillTexture(fluid);
        Function atlas = Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS);
        TextureAtlasSprite sprite = (TextureAtlasSprite)atlas.apply(texture);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        int color = extensions.getTintColor(fluid);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        guiGraphics.blit(x, y, 0, width, height, sprite);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderChemicalStack(GuiGraphics guiGraphics, ChemicalStack stack, int x, int y, int width, int height) {
        if (stack.isEmpty()) {
            return;
        }
        Chemical chemical = stack.getChemical();
        ResourceLocation sprite = chemical.getIcon();
        Function atlas = Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS);
        TextureAtlasSprite spriteObj = (TextureAtlasSprite)atlas.apply(sprite);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)spriteObj.atlasLocation());
        int color = stack.getChemicalTint();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        guiGraphics.blit(x, y, 0, width, height, spriteObj);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        for (Slot slot : ((ExporterMenu)this.menu).slots) {
            if (!this.isHovering(slot, mouseX, mouseY)) continue;
            if (slot instanceof GhostSlot) {
                GhostSlot ghostSlot = (GhostSlot)slot;
                ItemStack stack = ghostSlot.getItem();
                if (!stack.isEmpty()) {
                    guiGraphics.renderTooltip(this.font, stack, mouseX, mouseY);
                    continue;
                }
                if (ghostSlot.hasFluid() && !ghostSlot.getGhostFluid().isEmpty()) {
                    Component fluidName = ghostSlot.getGhostFluid().getHoverName();
                    guiGraphics.renderTooltip(this.font, fluidName, mouseX, mouseY);
                    continue;
                }
                if (ghostSlot.hasChemical() && ModList.get().isLoaded("mekanism") && ghostSlot.getGhostChemical() != null) {
                    Object chemicalObj = ghostSlot.getGhostChemical();
                    if (chemicalObj == null) {
                        return;
                    }
                    ChemicalStack chemicalStack = (ChemicalStack)chemicalObj;
                    Component chemicalName = chemicalStack.getTextComponent();
                    guiGraphics.renderTooltip(this.font, chemicalName, mouseX, mouseY);
                    continue;
                }
                MutableComponent emptyText = Component.translatable((String)"tooltip.routers.exporter_filter_slots").withStyle(ChatFormatting.GRAY);
                guiGraphics.renderTooltip(this.font, (Component)emptyText, mouseX, mouseY);
                continue;
            }
            if (!slot.getItem().isEmpty() || slot.index < 18 || slot.index > 26) continue;
            MutableComponent upgradeText = Component.translatable((String)"tooltip.routers.exporter_upgrades_slots").withStyle(ChatFormatting.GRAY);
            guiGraphics.renderTooltip(this.font, (Component)upgradeText, mouseX, mouseY);
        }
    }

    private boolean isHovering(Slot slot, double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos + slot.x) && mouseX < (double)(this.leftPos + slot.x + 16) && mouseY >= (double)(this.topPos + slot.y) && mouseY < (double)(this.topPos + slot.y + 16);
    }
}

