/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.event;

import com.benbenlaw.routers.block.ExporterBlock;
import com.benbenlaw.routers.block.ImporterBlock;
import com.benbenlaw.routers.block.entity.ExporterBlockEntity;
import com.benbenlaw.routers.item.RoutersItems;
import com.benbenlaw.routers.particle.RoutersParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="routers", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onRenderLevelLast(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            if (!mc.player.getMainHandItem().is((Item)RoutersItems.ROUTER_CONNECTOR.get()) && !mc.player.getOffhandItem().is((Item)RoutersItems.ROUTER_CONNECTOR.get())) {
                return;
            }
            ClientLevel level = mc.level;
            BlockPos playerPos = mc.player.blockPosition();
            int radius = 10;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = playerPos.offset(x, y, z);
                        BlockEntity be = level.getBlockEntity(pos);
                        if (!(be instanceof ExporterBlockEntity)) continue;
                        ExporterBlockEntity exporter = (ExporterBlockEntity)be;
                        for (BlockPos targetPos : exporter.getImporterPositions()) {
                            Vec3 exporterPos = Vec3.atCenterOf((Vec3i)exporter.getBlockPos());
                            Vec3 importerPos = Vec3.atCenterOf((Vec3i)targetPos);
                            if (!(exporter.getBlockState().getBlock() instanceof ExporterBlock)) {
                                return;
                            }
                            Direction exporterFacing = (Direction)exporter.getBlockState().getValue((Property)ExporterBlock.FACING);
                            exporterPos = ClientEvents.getAdjustedPos(exporterPos, exporterFacing);
                            if (!(level.getBlockState(targetPos).getBlock() instanceof ImporterBlock)) {
                                return;
                            }
                            Direction importerFacing = (Direction)level.getBlockState(targetPos).getValue((Property)ImporterBlock.FACING);
                            importerPos = ClientEvents.getAdjustedPos(importerPos, importerFacing);
                            long time = level.getGameTime();
                            double t = (double)(time % 20L) / 20.0;
                            Vec3 particlePos = exporterPos.add(importerPos.subtract(exporterPos).scale(t));
                            level.addParticle((ParticleOptions)RoutersParticles.EXPORTER_PARTICLES.get(), particlePos.x, particlePos.y + 0.5, particlePos.z, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    private static Vec3 getAdjustedPos(Vec3 pos, Direction facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> pos.add(0.0, -0.7, 0.0);
            case Direction.UP -> pos.add(0.0, -0.3, 0.0);
            case Direction.NORTH -> pos.add(0.0, -0.5, -0.3);
            case Direction.SOUTH -> pos.add(0.0, -0.5, 0.3);
            case Direction.EAST -> pos.add(0.3, -0.5, 0.0);
            case Direction.WEST -> pos.add(-0.3, -0.5, 0.0);
        };
    }
}

