/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.block;

import com.benbenlaw.routers.block.entity.ExporterBlockEntity;
import com.benbenlaw.routers.block.entity.RoutersBlockEntities;
import com.benbenlaw.routers.item.RoutersDataComponents;
import com.benbenlaw.routers.item.RoutersItems;
import com.benbenlaw.routers.networking.packets.SyncFluidListToClient;
import com.benbenlaw.routers.screen.ExporterMenu;
import com.mojang.serialization.MapCodec;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExporterBlock
extends BaseEntityBlock {
    public static final MapCodec<ExporterBlock> CODEC = ExporterBlock.simpleCodec(ExporterBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final Map<Direction, VoxelShape> SHAPE_MAP = new EnumMap<Direction, VoxelShape>(Direction.class);

    private static VoxelShape buildShape(Direction direction) {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.3125, (double)0.84375, (double)0.6875, (double)0.6875, (double)0.90625));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.3125, (double)0.8125, (double)0.6875, (double)0.6875, (double)0.9375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.9375, (double)0.75, (double)0.75, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.75, (double)0.999375, (double)0.625, (double)0.8125, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.75, (double)0.999375, (double)0.4375, (double)0.8125, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.1875, (double)0.999375, (double)0.4375, (double)0.25, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.1875, (double)0.999375, (double)0.625, (double)0.25, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.5625, (double)0.999375, (double)0.25, (double)0.625, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.375, (double)0.999375, (double)0.25, (double)0.4375, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.5625, (double)0.999375, (double)0.8125, (double)0.625, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.375, (double)0.999375, (double)0.8125, (double)0.4375, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.4375, (double)0.75, (double)0.5625, (double)0.5625, (double)0.8125));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.5, (double)0.625, (double)0.6875, (double)0.5, (double)0.75));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.3125, (double)0.625, (double)0.5, (double)0.6875, (double)0.75));
        return ExporterBlock.rotateShape(direction, shape);
    }

    private static VoxelShape rotateShape(Direction to, VoxelShape shape) {
        if (Direction.SOUTH == to) {
            return shape;
        }
        VoxelShape rotated = Shapes.empty();
        for (AABB box : shape.toAabbs()) {
            double minX = box.minX;
            double minY = box.minY;
            double minZ = box.minZ;
            double maxX = box.maxX;
            double maxY = box.maxY;
            double maxZ = box.maxZ;
            AABB newBox = switch (to) {
                case Direction.NORTH -> new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
                case Direction.EAST -> new AABB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX);
                case Direction.WEST -> new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
                case Direction.UP -> new AABB(minX, 1.0 - maxZ, minY, maxX, 1.0 - minZ, maxY);
                case Direction.DOWN -> new AABB(minX, minZ, 1.0 - maxY, maxX, maxZ, 1.0 - minY);
                default -> box;
            };
            rotated = Shapes.or((VoxelShape)rotated, (VoxelShape)Shapes.box((double)newBox.minX, (double)newBox.minY, (double)newBox.minZ, (double)newBox.maxX, (double)newBox.maxY, (double)newBox.maxZ));
        }
        return rotated;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_MAP.get(state.getValue((Property)FACING));
    }

    public ExporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof ExporterBlockEntity) {
            ((ExporterBlockEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity be = level.getBlockEntity(blockPos);
        if (!(be instanceof ExporterBlockEntity)) {
            return ItemInteractionResult.SUCCESS;
        }
        ExporterBlockEntity exporter = (ExporterBlockEntity)be;
        if (stack.is(RoutersItems.ROUTER_CONNECTOR)) {
            BlockPos importerPos = (BlockPos)stack.get((DataComponentType)RoutersDataComponents.IMPORTER_POSITION.get());
            if (importerPos != null) {
                exporter.toggleImporter(importerPos, player);
            }
        } else {
            ContainerData data = exporter.data;
            player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ExporterMenu(windowId, playerInventory, blockPos, data), (Component)Component.translatable((String)"block.routers.exporter_block")), buf -> buf.writeBlockPos(blockPos));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncFluidListToClient(blockPos, (List<FluidStack>)exporter.getFluidFilters()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getClickedFace().getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.routers.exporter").withStyle(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.routers.hold_shift").withStyle(ChatFormatting.YELLOW));
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ExporterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return ExporterBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RoutersBlockEntities.EXPORTER_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }

    static {
        SHAPE_MAP.put(Direction.EAST, ExporterBlock.buildShape(Direction.WEST));
        SHAPE_MAP.put(Direction.WEST, ExporterBlock.buildShape(Direction.EAST));
        SHAPE_MAP.put(Direction.NORTH, ExporterBlock.buildShape(Direction.NORTH));
        SHAPE_MAP.put(Direction.SOUTH, ExporterBlock.buildShape(Direction.SOUTH));
        SHAPE_MAP.put(Direction.UP, ExporterBlock.buildShape(Direction.DOWN));
        SHAPE_MAP.put(Direction.DOWN, ExporterBlock.buildShape(Direction.UP));
    }
}

