/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.block;

import com.benbenlaw.routers.block.ExporterBlock;
import com.benbenlaw.routers.block.ImporterBlock;
import com.benbenlaw.routers.item.RoutersItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RoutersBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"routers");
    public static final DeferredBlock<ImporterBlock> IMPORTER_BLOCK = RoutersBlocks.registerBlock("importer_block", () -> new ImporterBlock(BlockBehaviour.Properties.of().strength(2.0f).noOcclusion()));
    public static final DeferredBlock<ExporterBlock> EXPORTER_BLOCK = RoutersBlocks.registerBlock("exporter_block", () -> new ExporterBlock(BlockBehaviour.Properties.of().strength(2.0f).noOcclusion()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        RoutersBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        RoutersItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

