/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.block.entity.client;

import com.benbenlaw.routers.block.ExporterBlock;
import com.benbenlaw.routers.block.ImporterBlock;
import com.benbenlaw.routers.block.entity.ExporterBlockEntity;
import com.benbenlaw.routers.block.particle.RoutersParticles;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ExporterBlockEntityRenderer
implements BlockEntityRenderer<ExporterBlockEntity> {
    public ExporterBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ExporterBlockEntity exporterBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int combinedOverlayIn) {
        ClientLevel level = Minecraft.getInstance().level;
        List<BlockPos> importerPositions = exporterBlockEntity.getImporterPositions();
        Vec3 baseExporterPos = Vec3.atCenterOf((Vec3i)exporterBlockEntity.getBlockPos());
        assert (level != null);
        for (BlockPos targetPos : importerPositions) {
            Vec3 exporterPos = baseExporterPos;
            Vec3 importerPos = Vec3.atCenterOf((Vec3i)targetPos);
            if (level.getBlockState(exporterBlockEntity.getBlockPos()).getBlock() instanceof ExporterBlock) {
                Direction direction = (Direction)level.getBlockState(exporterBlockEntity.getBlockPos()).getValue((Property)ExporterBlock.FACING);
                exporterPos = this.getAdjustedPos(exporterPos, direction);
            }
            if (level.getBlockState(targetPos).getBlock() instanceof ImporterBlock) {
                Direction facing = (Direction)level.getBlockState(targetPos).getValue((Property)ImporterBlock.FACING);
                importerPos = this.getAdjustedPos(importerPos, facing);
            }
            long time = System.currentTimeMillis();
            double t = (double)(time % 1000L) / 1000.0;
            Vec3 particlePos = exporterPos.add(importerPos.subtract(exporterPos).scale(t));
            level.addParticle((ParticleOptions)RoutersParticles.EXPORTER_PARTICLES.get(), particlePos.x, particlePos.y + 0.5, particlePos.z, 0.0, 0.0, 0.0);
        }
    }

    private Vec3 getAdjustedPos(Vec3 pos, Direction facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> pos.add(0.0, -0.7, 0.0);
            case Direction.UP -> pos.add(0.0, -0.3, 0.0);
            case Direction.NORTH -> pos.add(0.0, -0.5, -0.3);
            case Direction.SOUTH -> pos.add(0.0, -0.5, 0.3);
            case Direction.EAST -> pos.add(0.3, -0.5, 0.0);
            case Direction.WEST -> pos.add(-0.3, -0.5, 0.0);
        };
    }
}

