/*
 * Decompiled with CFR 0.152.
 */
package de.zhylon_gaming.ms.combatlock.Commands;

import de.zhylon_gaming.ms.combatlock.ZhylonPlugin;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CombatLockCheckCommand
implements CommandExecutor {
    private final ZhylonPlugin plugin;

    public CombatLockCheckCommand(ZhylonPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("combatlock.check")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /combatlock-check <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        boolean inCombat = this.plugin.CLManager.isInCombat(target);
        if (inCombat) {
            long secondsLeft = (this.plugin.CLManager.getCombatEndTime(target) - System.currentTimeMillis()) / 1000L;
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " is in combat for " + secondsLeft + " more seconds.");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " is not in combat.");
        }
        return true;
    }
}

