/*
 * Decompiled with CFR 0.152.
 */
package de.zhylon_gaming.ms.combatlock.Commands;

import de.zhylon_gaming.ms.combatlock.ZhylonPlugin;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class CombatLockTimeoutCommand
implements CommandExecutor {
    private final ZhylonPlugin plugin;

    public CombatLockTimeoutCommand(ZhylonPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("combatlock.timeout")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            int currentTimeout = this.plugin.CLManager.getTimeout();
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current Combat Lock timeout: " + String.valueOf(ChatColor.GREEN) + currentTimeout + " seconds");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Usage: /combatlock-timeout <seconds>");
            return true;
        }
        if (args.length == 1) {
            try {
                int timeout = Integer.parseInt(args[0]);
                if (timeout < 0 || timeout > 3600) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Please enter a timeout between 0 and 3600 seconds.");
                    return true;
                }
                this.plugin.CLManager.setTimeout(timeout);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Combat Lock timeout set to " + timeout + " seconds.");
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number. Please enter a valid integer.");
            }
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /combatlock-timeout <seconds>");
        return true;
    }
}

