/*
 * Decompiled with CFR 0.152.
 */
package de.zhylon_gaming.ms.combatlock.Managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatLockManager {
    private final Map<UUID, Long> combatTimestamps = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitRunnable> activeTimers = new HashMap<UUID, BukkitRunnable>();
    private int timeoutSeconds;
    private final Plugin plugin;
    private boolean enabled;
    private boolean allowByPass;

    public CombatLockManager(Plugin plugin) {
        this.plugin = plugin;
        this.timeoutSeconds = plugin.getConfig().getInt("combatlock-timeout", 10);
        this.enabled = plugin.getConfig().getBoolean("combatlock-enabled", true);
        this.allowByPass = plugin.getConfig().getBoolean("combatlock-bypass-enabled", false);
    }

    public int getTimeout() {
        return this.timeoutSeconds;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isBypassEnabled() {
        return this.allowByPass;
    }

    public void toggle(boolean enabled) {
        this.enabled = enabled;
        this.plugin.getConfig().set("combatlock-enabled", (Object)enabled);
        this.plugin.saveConfig();
        if (!enabled) {
            for (BukkitRunnable task : this.activeTimers.values()) {
                task.cancel();
            }
            this.activeTimers.clear();
            this.clear();
        }
    }

    public void toggleBypass() {
        this.allowByPass = !this.allowByPass;
        this.plugin.getConfig().set("combatlock-bypass-enabled", (Object)this.allowByPass);
        this.plugin.saveConfig();
    }

    public void setTimeout(int seconds) {
        if (seconds < 0 || seconds > 3600) {
            seconds = 10;
        }
        this.plugin.getConfig().set("combatlock-timeout", (Object)seconds);
        this.plugin.saveConfig();
        this.timeoutSeconds = seconds;
    }

    public void tag(final Player player) {
        if (this.allowByPass && player.hasPermission("combatlock.bypass")) {
            return;
        }
        if (!this.isTagged(player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are now in combat! Commands are locked.");
        }
        final UUID uuid = player.getUniqueId();
        long endTime = System.currentTimeMillis() + (long)this.timeoutSeconds * 1000L;
        this.combatTimestamps.put(uuid, endTime);
        if (this.activeTimers.containsKey(uuid)) {
            this.activeTimers.get(uuid).cancel();
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                if (!CombatLockManager.this.isInCombat(player)) {
                    CombatLockManager.this.sendActionBar(player, "\u00a7aCombat has ended!");
                    CombatLockManager.this.untag(player);
                    this.cancel();
                    return;
                }
                long secondsLeft = (CombatLockManager.this.combatTimestamps.get(uuid) - System.currentTimeMillis()) / 1000L;
                CombatLockManager.this.sendActionBar(player, "\u00a7cCombat Lock: " + secondsLeft + " seconds remaining");
            }
        };
        runnable.runTaskTimer(this.plugin, 0L, 20L);
        this.activeTimers.put(uuid, runnable);
    }

    private void sendActionBar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
    }

    public boolean isTagged(Player player) {
        boolean enabled = this.plugin.getConfig().getBoolean("combatlock-enabled", true);
        if (!enabled) {
            return false;
        }
        Long lastHit = this.combatTimestamps.get(player.getUniqueId());
        if (lastHit == null) {
            return false;
        }
        long elapsed = (System.currentTimeMillis() - lastHit) / 1000L;
        return elapsed < (long)this.timeoutSeconds;
    }

    public boolean isInCombat(Player player) {
        Long endTime = this.combatTimestamps.get(player.getUniqueId());
        return endTime != null && System.currentTimeMillis() < endTime;
    }

    public long getCombatEndTime(Player player) {
        Long endTime = this.combatTimestamps.get(player.getUniqueId());
        return endTime != null ? endTime : 0L;
    }

    public void untag(Player player) {
        this.combatTimestamps.remove(player.getUniqueId());
        if (this.activeTimers.containsKey(player.getUniqueId())) {
            this.activeTimers.get(player.getUniqueId()).cancel();
            this.activeTimers.remove(player.getUniqueId());
        }
    }

    public void clear() {
        this.combatTimestamps.clear();
    }
}

