/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import dev.xkmc.fruitsdelight.content.block.BaseCakeBlock;
import dev.xkmc.fruitsdelight.init.food.FDFood;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MangosteenCakeBlock
extends BaseCakeBlock {
    public static final int MAX_BITES = 3;
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)3);
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0)};

    public MangosteenCakeBlock(BlockBehaviour.Properties properties) {
        super(properties, BITES, 3, true);
    }

    public VoxelShape getShape(BlockState p_51222_, BlockGetter p_51223_, BlockPos p_51224_, CollisionContext p_51225_) {
        return SHAPE_BY_BITE[(Integer)p_51222_.getValue((Property)BITES)];
    }

    @Override
    protected void eat(Player player) {
        player.getFoodData().eat(3, 0.6f);
        Item item = (Item)FDFood.MANGOSTEEN_CAKE.item.get();
        FoodProperties food = item.getFoodProperties(item.getDefaultInstance(), (LivingEntity)player);
        if (food == null || player.level().isClientSide) {
            return;
        }
        for (FoodProperties.PossibleEffect e : food.effects()) {
            MobEffectInstance ins = e.effect();
            float f = e.probability();
            if (!(player.level().getRandom().nextDouble() < (double)f)) continue;
            player.addEffect(new MobEffectInstance(ins.getEffect(), ins.getDuration() / 3, ins.getAmplifier()));
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BITES});
    }
}

