/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.food;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.fruitsdelight.content.cauldrons.CauldronDispenseBehavior;
import dev.xkmc.fruitsdelight.content.cauldrons.CauldronRecipe;
import dev.xkmc.fruitsdelight.content.cauldrons.CauldronRenderHandler;
import dev.xkmc.fruitsdelight.content.cauldrons.FDCauldronBlock;
import dev.xkmc.fruitsdelight.content.cauldrons.FDCauldronInteraction;
import dev.xkmc.fruitsdelight.content.cauldrons.FruitCauldronBlock;
import dev.xkmc.fruitsdelight.content.cauldrons.JamCauldronBlock;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.food.FDFood;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.registrate.FDItems;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;

public class FDCauldrons {
    public static final BlockEntry<FDCauldronBlock> LEMON = FDCauldrons.simple("lemonade_cauldron", FDCauldronBlock::new);
    public static final BlockEntry<FruitCauldronBlock>[] FRUIT;
    public static final BlockEntry<JamCauldronBlock>[] JAM;
    public static final BlockEntry<JamCauldronBlock>[] JELLO;
    public static final ItemEntry<Item> FAKE_CAULDRON;

    public static void register() {
    }

    public static void init() {
        CauldronRecipe.create(CauldronInteraction.WATER, (Item)FAKE_CAULDRON.get(), (Item)FDFood.LEMON_SLICE.item.get(), FDCauldronInteraction.of(state -> (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) == 3 ? ((FDCauldronBlock)((Object)((Object)LEMON.get()))).defaultBlockState() : null), ((FDCauldronBlock)((Object)LEMON.get())).asItem());
        IntegerProperty fruitProp = FruitCauldronBlock.LEVEL;
        IntegerProperty jamProp = JamCauldronBlock.LEVEL;
        int max = 12;
        for (FruitType type : FruitType.values()) {
            int level = 4 / type.jamCost;
            int index = type.ordinal();
            FruitCauldronBlock fruit = (FruitCauldronBlock)((Object)FRUIT[index].get());
            JamCauldronBlock jam = (JamCauldronBlock)((Object)JAM[index].get());
            JamCauldronBlock jello = (JamCauldronBlock)((Object)JELLO[index].get());
            CauldronRecipe.create(CauldronInteraction.WATER, (Item)FAKE_CAULDRON.get(), type.getJam(), 3, FDCauldronInteraction.of(state -> (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) == 3 ? (BlockState)fruit.defaultBlockState().setValue((Property)fruitProp, (Comparable)Integer.valueOf(4)) : null), fruit.asItem());
            CauldronRecipe.create((FDCauldronBlock)((Object)LEMON.get()), type.getFruit(), 12 / level, FDCauldronInteraction.withHeat(state -> (BlockState)fruit.defaultBlockState().setValue((Property)fruitProp, (Comparable)Integer.valueOf(level))), fruit.asItem());
            fruit.getInteractions().map().put(type.getFruit(), FDCauldronInteraction.withHeat(state -> (Integer)state.getValue((Property)fruitProp) == max ? null : (BlockState)state.setValue((Property)fruitProp, (Comparable)Integer.valueOf(Math.min(max, (Integer)state.getValue((Property)fruitProp) + level)))));
            fruit.getInteractions().map().put(type.getJam(), FDCauldronInteraction.of(state -> (Integer)state.getValue((Property)fruitProp) == max ? null : (BlockState)state.setValue((Property)fruitProp, (Comparable)Integer.valueOf(Math.min(max, (Integer)state.getValue((Property)fruitProp) + 4)))));
            CauldronRecipe.create(fruit, Items.SUGAR, 1, FDCauldronInteraction.withHeat(state -> (Integer)state.getValue((Property)fruitProp) == max ? jam.defaultBlockState() : null), jam.asItem());
            CauldronRecipe.create(jam, Items.SLIME_BALL, 1, FDCauldronInteraction.withHeat(state -> (BlockState)jello.defaultBlockState().setValue((Property)jamProp, (Comparable)((Integer)state.getValue((Property)jamProp)))), jello.asItem());
            CauldronRecipe.empty(jam, Items.GLASS_BOTTLE, 3, FDCauldronInteraction.of(state -> (Integer)state.getValue((Property)jamProp) == 1 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)state.setValue((Property)jamProp, (Comparable)Integer.valueOf((Integer)state.getValue((Property)jamProp) - 1)), type.getJam().getDefaultInstance(), SoundEvents.BOTTLE_FILL), Items.CAULDRON);
            CauldronRecipe.empty(jello, Items.BOWL, 3, FDCauldronInteraction.of(state -> (Integer)state.getValue((Property)jamProp) == 1 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)state.setValue((Property)jamProp, (Comparable)Integer.valueOf((Integer)state.getValue((Property)jamProp) - 1)), type.getJello().getDefaultInstance(), SoundEvents.BOTTLE_FILL), Items.CAULDRON);
            DispenserBlock.registerBehavior((ItemLike)type.getJam(), (DispenseItemBehavior)new CauldronDispenseBehavior());
        }
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)FDFood.LEMON_SLICE.item.get()), (DispenseItemBehavior)new CauldronDispenseBehavior());
    }

    private static <T extends FDCauldronBlock> BlockEntry<T> simple(String id, BiFunction<BlockBehaviour.Properties, String, T> factory) {
        return ((BlockBuilder)FruitsDelight.REGISTRATE.block(id, p -> (FDCauldronBlock)((Object)((Object)factory.apply(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER_CAULDRON), "fruitsdelight_" + id)))).blockstate((ctx, pvd) -> ((FDCauldronBlock)((Object)((Object)ctx.get()))).build(ctx, (RegistrateBlockstateProvider)pvd)).loot((pvd, block) -> pvd.dropOther((Block)block, (ItemLike)Items.CAULDRON)).color(() -> () -> CauldronRenderHandler::getBlockColor).item().removeTab(FruitsDelight.TAB.key()).color(() -> () -> CauldronRenderHandler::getItemColor).build()).lang(FDItems.toEnglishName(id)).tag(new TagKey[]{BlockTags.CAULDRONS}).register();
    }

    static {
        int size = FruitType.values().length;
        FRUIT = new BlockEntry[size];
        JAM = new BlockEntry[size];
        JELLO = new BlockEntry[size];
        for (int i = 0; i < size; ++i) {
            FruitType type = FruitType.values()[i];
            String name = type.name().toLowerCase(Locale.ROOT);
            FDCauldrons.FRUIT[i] = FDCauldrons.simple(name + "_cauldron", (p, s) -> new FruitCauldronBlock((BlockBehaviour.Properties)p, type, (String)s));
            FDCauldrons.JAM[i] = FDCauldrons.simple(name + "_jam_cauldron", (p, s) -> new JamCauldronBlock((BlockBehaviour.Properties)p, type, (String)s));
            FDCauldrons.JELLO[i] = FDCauldrons.simple(name + "_jello_cauldron", (p, s) -> new JamCauldronBlock((BlockBehaviour.Properties)p, type, (String)s));
        }
        FAKE_CAULDRON = FruitsDelight.REGISTRATE.item("dummy_cauldron", Item::new).lang("Water Cauldron").model((ctx, pvd) -> CauldronRenderHandler.gui((ItemModelBuilder)pvd.withExistingParent(ctx.getName(), "block/water_cauldron_full"))).color(() -> () -> CauldronRenderHandler::getItemColor).removeTab(FruitsDelight.TAB.key()).register();
    }
}

