/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.registrate;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.fruitsdelight.content.block.JamBottleBlock;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.food.FoodType;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.food.RecordFood;
import dev.xkmc.l2core.init.reg.simple.DCReg;
import dev.xkmc.l2core.init.reg.simple.DCVal;
import dev.xkmc.l2core.init.reg.simple.EnumCodec;
import dev.xkmc.l2core.init.reg.simple.Reg;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class FDItems {
    private static final Set<String> SMALL_WORDS;
    public static final BlockEntry<JamBottleBlock>[] JAM;
    public static final ItemEntry<Item>[] JELLO;
    public static final DCReg DC;
    public static final DCVal<List<FruitType>> FRUITS;

    public static String toEnglishName(String internalName) {
        return Arrays.stream(internalName.split("_")).map(e -> SMALL_WORDS.contains(e) ? e : StringUtils.capitalize((String)e)).collect(Collectors.joining(" "));
    }

    public static void register() {
    }

    private static int jamColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
        Block block = state.getBlock();
        if (block instanceof JamBottleBlock) {
            JamBottleBlock b = (JamBottleBlock)block;
            return b.fruit.color;
        }
        return -1;
    }

    static {
        FoodType food;
        String name;
        FruitType fruit;
        int j;
        SMALL_WORDS = Set.of("of", "the", "with");
        DC = DCReg.of((Reg)FruitsDelight.REG);
        FRUITS = DC.enumVal("fruits", EnumCodec.of(FruitType.class, (Enum[])FruitType.values()).toList());
        int fruits = FruitType.values().length;
        JAM = new BlockEntry[fruits];
        JELLO = new ItemEntry[fruits];
        for (j = 0; j < fruits; ++j) {
            fruit = FruitType.values()[j];
            name = fruit.name().toLowerCase(Locale.ROOT);
            food = FoodType.JAM;
            FDItems.JAM[j] = ((BlockBuilder)((ItemBuilder)FruitsDelight.REGISTRATE.block(name + "_jam", p -> new JamBottleBlock(BlockBehaviour.Properties.of().strength(0.3f).sound(SoundType.GLASS).noOcclusion(), fruit)).blockstate((ctx, pvd) -> pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/jam_bottle_block")))).texture("cap_top", pvd.modLoc("block/jam_bottle_cap_top"))).texture("cap_bottom", pvd.modLoc("block/jam_bottle_cap_bottom"))).texture("body", pvd.modLoc("block/jam_bottle_body"))).texture("content", pvd.modLoc("block/jam_content"))).renderType("cutout"))).item((b, p) -> food.build((Item.Properties)p, new RecordFood(fruit, food), (Block)b)).transform(b -> b.model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/jam_bottle"), pvd.modLoc("item/" + fruit.name().toLowerCase(Locale.ROOT) + "_jam")})).color(() -> () -> (stack, layer) -> layer == 0 ? -1 : fruit.color))).tag(food.tags).build()).color(() -> () -> FDItems::jamColor).lang(FDItems.toEnglishName(name) + " Jam").register();
        }
        for (j = 0; j < fruits; ++j) {
            fruit = FruitType.values()[j];
            name = fruit.name().toLowerCase(Locale.ROOT);
            food = FoodType.JELLO;
            FDItems.JELLO[j] = ((ItemBuilder)FruitsDelight.REGISTRATE.item(name + "_jello", p -> food.build((Item.Properties)p, new RecordFood(fruit, food))).transform(b -> food.model(b, 0, fruit))).lang(FDItems.toEnglishName(name) + " Jello").tag(food.tags).register();
        }
    }
}

