/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.biogas;

import com.zombie_cute.mc.bakingdelight.block.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.block.ModBlocks;
import com.zombie_cute.mc.bakingdelight.block.biogas.BiogasDigesterControllerBlockEntity;
import com.zombie_cute.mc.bakingdelight.block.biogas.GasCanisterBlock;
import com.zombie_cute.mc.bakingdelight.fluid.ModFluid;
import com.zombie_cute.mc.bakingdelight.screen.custom.GasCanisterScreenHandler;
import com.zombie_cute.mc.bakingdelight.sound.ModSounds;
import com.zombie_cute.mc.bakingdelight.tag.TagKeys;
import com.zombie_cute.mc.bakingdelight.util.FluidStack;
import com.zombie_cute.mc.bakingdelight.util.ModConfig;
import java.util.HashSet;
import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3913;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GasCanisterBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory {
    private int gasValue = 0;
    private int cycleInt = 0;
    public final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return FluidStack.convertMbToDroplets(GasCanisterBlockEntity.getMaxCapacity());
        }

        protected void onFinalCommit() {
            GasCanisterBlockEntity.this.method_5431();
        }
    };
    public static final String GAS_CANISTER_NAME = "display_name.bakingdelight.gas_canister_name";
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> GasCanisterBlockEntity.this.gasValue;
                case 1 -> GasCanisterBlockEntity.this.cycleInt;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    GasCanisterBlockEntity.this.gasValue = value;
                    break;
                }
                case 1: {
                    GasCanisterBlockEntity.this.cycleInt = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int tick = 20;
    private float explodeTime = 0.0f;

    public GasCanisterBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.GAS_CANISTER_BLOCK_ENTITY, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, GasCanisterBlockEntity blockEntity) {
        class_2586 class_25862;
        if (world.field_9236) {
            return;
        }
        this.gasValue = (int)FluidStack.convertDropletsToMb(this.fluidStorage.amount);
        --blockEntity.tick;
        switch (this.tick) {
            case 3: 
            case 20: {
                this.cycleInt = 0;
                break;
            }
            case 7: 
            case 17: {
                this.cycleInt = 1;
                break;
            }
            case 10: 
            case 15: {
                this.cycleInt = 2;
                break;
            }
            case 12: {
                this.cycleInt = 3;
                break;
            }
            case 0: {
                this.tick = 20;
            }
        }
        if (GasCanisterBlockEntity.allowExplode() && this.fluidIsGas()) {
            if (GasCanisterBlockEntity.isDangerBlock(world.method_8320(pos.method_10074()).method_26204()) || GasCanisterBlockEntity.isDangerBlock(world.method_8320(pos.method_10084()).method_26204()) || GasCanisterBlockEntity.isDangerBlock(world.method_8320(pos.method_10095()).method_26204()) || GasCanisterBlockEntity.isDangerBlock(world.method_8320(pos.method_10072()).method_26204()) || GasCanisterBlockEntity.isDangerBlock(world.method_8320(pos.method_10067()).method_26204()) || GasCanisterBlockEntity.isDangerBlock(world.method_8320(pos.method_10078()).method_26204())) {
                this.randomExplode(world);
            } else if (world.method_8597().comp_644() && !GasCanisterBlockEntity.allowNether()) {
                this.randomExplode(world);
            } else if (this.fluidStorage.amount >= FluidStack.convertMbToDroplets(GasCanisterBlockEntity.getMaxCapacity())) {
                world.method_8501(pos, class_2246.field_10124.method_9564());
                world.method_8537(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (float)this.getGasValue() / 1000.0f, true, class_1937.class_7867.field_40889);
            }
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)GasCanisterBlock.FACING);
        class_2338 facingBlock = pos;
        class_2338 underBlock = pos;
        switch (direction) {
            case field_11034: {
                facingBlock = pos.method_10089(1);
                underBlock = pos.method_10089(1).method_10087(1);
                break;
            }
            case field_11035: {
                facingBlock = pos.method_10077(1);
                underBlock = pos.method_10077(1).method_10087(1);
                break;
            }
            case field_11039: {
                facingBlock = pos.method_10088(1);
                underBlock = pos.method_10088(1).method_10087(1);
                break;
            }
            case field_11043: {
                facingBlock = pos.method_10076(1);
                underBlock = pos.method_10076(1).method_10087(1);
            }
        }
        if ((this.fluidIsGas() || ((FluidVariant)this.fluidStorage.variant).isBlank()) && world.method_8320(facingBlock).method_26204().equals(ModBlocks.BIOGAS_DIGESTER_IO) && (class_25862 = world.method_8321(underBlock)) instanceof BiogasDigesterControllerBlockEntity) {
            BiogasDigesterControllerBlockEntity entity = (BiogasDigesterControllerBlockEntity)class_25862;
            if (this.gasValue < GasCanisterBlockEntity.getMaxCapacity()) {
                if (entity.getGasValue() >= 5) {
                    this.playSound(ModSounds.BLOCK_GAS_CANISTER_FILLING, 0.5f, 0.8f);
                    entity.reduceGas(5);
                    transaction = Transaction.openOuter();
                    try {
                        this.fluidStorage.insert((TransferVariant)FluidVariant.of((class_3611)ModFluid.STILL_LIQUEFIED_BIOGAS), FluidStack.convertMbToDroplets(5L), (TransactionContext)transaction);
                        transaction.commit();
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                    this.method_5431();
                } else if (entity.getGasValue() > 0) {
                    this.playSound(ModSounds.BLOCK_GAS_CANISTER_FILLING, 0.5f, 0.8f);
                    entity.reduceGas(1);
                    transaction = Transaction.openOuter();
                    try {
                        this.fluidStorage.insert((TransferVariant)FluidVariant.of((class_3611)ModFluid.STILL_LIQUEFIED_BIOGAS), FluidStack.convertMbToDroplets(1L), (TransactionContext)transaction);
                        transaction.commit();
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                    this.method_5431();
                }
            }
        }
    }

    public boolean fluidIsGas() {
        return GasCanisterBlockEntity.fluidIsGas(((FluidVariant)this.fluidStorage.variant).getFluid());
    }

    public static boolean fluidIsGas(class_3611 fluid) {
        for (class_6880 registryEntry : class_7923.field_41173.method_40286(TagKeys.GAS)) {
            if (registryEntry.comp_349() != fluid) continue;
            return true;
        }
        return false;
    }

    public static boolean isDangerBlock(class_2248 block) {
        HashSet<class_2248> blockHashSet = new HashSet<class_2248>();
        for (class_6880 registryEntry : class_7923.field_41175.method_40286(TagKeys.DANGER_BLOCKS)) {
            blockHashSet.add((class_2248)registryEntry.comp_349());
        }
        blockHashSet.remove(class_2246.field_10593);
        blockHashSet.remove(ModBlocks.BURNING_GAS_COOKING_STOVE);
        return blockHashSet.contains(block);
    }

    public void randomExplode(class_1937 world) {
        if (this.gasValue > 999 && this.fluidIsGas()) {
            this.explodeTime += world.field_9229.method_43057();
            if (this.explodeTime > 60.0f) {
                world.method_8501(this.field_11867, class_2246.field_10124.method_9564());
                world.method_8537(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (float)(this.gasValue * 5 / GasCanisterBlockEntity.getMaxCapacity()), true, class_1937.class_7867.field_40889);
            }
        }
    }

    public void instantExplode(class_1937 world) {
        if (this.gasValue > 999 && this.fluidIsGas()) {
            world.method_8501(this.field_11867, class_2246.field_10124.method_9564());
            world.method_8537(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (float)(this.gasValue * 5 / GasCanisterBlockEntity.getMaxCapacity()), true, class_1937.class_7867.field_40889);
        }
    }

    public void onUse(class_1657 player, class_1937 world) {
        if (this.gasValue > 999 && this.fluidIsGas()) {
            if (player.method_6079().method_7909().equals(class_1802.field_8884)) {
                player.method_6079().method_7956(1, (class_1309)player, playerEntity -> playerEntity.method_20236(class_1268.field_5808));
                this.playSound(class_3417.field_15145, 1.0f, 1.0f);
                this.instantExplode(world);
            } else if (player.method_6047().method_7909().equals(class_1802.field_8884)) {
                player.method_6047().method_7956(1, (class_1309)player, playerEntity -> playerEntity.method_20236(class_1268.field_5810));
                this.playSound(class_3417.field_15145, 1.0f, 1.0f);
                this.instantExplode(world);
            } else if (player.method_6079().method_7909().equals(class_1802.field_8814)) {
                player.method_6079().method_7934(1);
                this.playSound(class_3417.field_15013, 1.0f, 1.0f);
                this.instantExplode(world);
            } else if (player.method_6047().method_7909().equals(class_1802.field_8814)) {
                player.method_6047().method_7934(1);
                this.playSound(class_3417.field_15013, 1.0f, 1.0f);
                this.instantExplode(world);
            }
        }
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        Objects.requireNonNull(this.field_11863).method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544("gas_canister.fluid_amount", this.fluidStorage.amount);
        nbt.method_10566("gas_canister.fluid_variant", (class_2520)((FluidVariant)this.fluidStorage.variant).toNbt());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.fluidStorage.variant = FluidVariant.fromNbt((class_2487)((class_2487)nbt.method_10580("gas_canister.fluid_variant")));
        this.fluidStorage.amount = nbt.method_10537("gas_canister.fluid_amount");
        this.method_5431();
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)GAS_CANISTER_NAME);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new GasCanisterScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public int getGasValue() {
        return this.gasValue;
    }

    public boolean reduceGas() {
        if (this.gasValue != 0 && this.fluidIsGas()) {
            this.fluidStorage.amount -= 27L;
            this.method_5431();
            return true;
        }
        return false;
    }

    public void method_5431() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
        super.method_5431();
    }

    public static int getMaxCapacity() {
        try {
            int value = ModConfig.gasCanisterVolume;
            if (value > 0) {
                return value;
            }
            return 6000;
        }
        catch (Throwable e) {
            return 6000;
        }
    }

    public static boolean allowExplode() {
        try {
            return ModConfig.allowGasCanisterExplode;
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static boolean allowNether() {
        try {
            return ModConfig.allowGasCanisterInNether;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

