/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.kitchenware;

import com.google.common.collect.Maps;
import com.zombie_cute.mc.bakingdelight.block.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.networking.packet.ItemStackSyncS2CPacket;
import com.zombie_cute.mc.bakingdelight.recipe.custom.FreezingRecipe;
import com.zombie_cute.mc.bakingdelight.screen.custom.FreezerScreenHandler;
import com.zombie_cute.mc.bakingdelight.sound.ModSounds;
import com.zombie_cute.mc.bakingdelight.tag.TagKeys;
import com.zombie_cute.mc.bakingdelight.util.block_util.ImplementedInventory;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.ACConsumer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FreezerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
class_1278,
ACConsumer {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)20, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int INPUT_SLOT_3 = 2;
    private static final int ICE_SLOT = 3;
    private static final int OUTPUT_SLOT = 4;
    public static final String FREEZER_NAME = "display_name.bakingdelight.freezer_name";
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> FreezerBlockEntity.this.progress;
                case 1 -> FreezerBlockEntity.this.maxProgress;
                case 2 -> FreezerBlockEntity.this.coolTime;
                case 3 -> FreezerBlockEntity.this.maxCoolTime;
                case 4 -> FreezerBlockEntity.this.experiences;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    FreezerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    FreezerBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    FreezerBlockEntity.this.coolTime = value;
                    break;
                }
                case 3: {
                    FreezerBlockEntity.this.maxCoolTime = value;
                    break;
                }
                case 4: {
                    FreezerBlockEntity.this.experiences = value;
                }
            }
        }

        public int method_17389() {
            return 5;
        }
    };
    private int progress = 0;
    private int maxProgress = 400;
    private int coolTime = 0;
    private int maxCoolTime = 1;
    private int experiences = 0;

    public FreezerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.FREEZER_ENTITY, pos, state);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        Objects.requireNonNull(this.field_11863).method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("freezer.progress", this.progress);
        nbt.method_10569("freezer.fuelTime", this.coolTime);
        nbt.method_10569("freezer.maxCoolTime", this.maxCoolTime);
        nbt.method_10569("freezer.experiences", this.experiences);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("freezer.progress");
        this.coolTime = nbt.method_10550("freezer.coolTime");
        this.maxCoolTime = nbt.method_10550("freezer.maxCoolTime");
        this.experiences = nbt.method_10550("freezer.experiences");
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)FREEZER_NAME);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FreezerScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, FreezerBlockEntity entity) {
        if (world.field_9236) {
            return;
        }
        if (this.isCool()) {
            --this.coolTime;
            if (world.method_8510() % 100L == 0L) {
                this.playSound(ModSounds.BLOCK_FREEZER_RUNNING, 0.3f, 0.8f);
            }
            if (this.isOutputSlotEmptyOrReceivable()) {
                if (this.hasRecipe(entity)) {
                    this.increaseCraftProgress();
                    this.method_5431();
                    if (this.hasCraftingFinished()) {
                        this.craftItem(entity);
                        for (int i = 0; i < 3; ++i) {
                            if (this.method_5438(i).getRecipeRemainder().method_7960()) continue;
                            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.method_5438(i).getRecipeRemainder().method_7972());
                        }
                        this.method_5434(0, 1);
                        this.method_5434(1, 1);
                        this.method_5434(2, 1);
                        this.resetProgress();
                    }
                } else if (this.progress != 0) {
                    this.resetProgress();
                }
            }
        } else {
            if (this.hasRecipe(entity)) {
                --this.progress;
            } else {
                this.resetProgress();
            }
            this.maxCoolTime = 60;
            this.method_5431();
        }
        if (FreezerBlockEntity.canUseAsIce(this.method_5438(3)) && this.coolTime == 0) {
            class_1799 ice = this.method_5438(3);
            this.maxCoolTime = this.coolTime = this.getCoolTime(ice);
            if (this.method_5438(3).method_7909() == class_1802.field_27876) {
                this.method_5447(3, class_1802.field_8550.method_7854());
            } else {
                this.method_5434(3, 1);
            }
        }
    }

    public static Map<class_1792, Integer> createCoolTimeMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8426, 20);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8081, 190);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8178, 1830);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8246, 15);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8749, 10);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_27876, 400);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, TagKeys.COLD_ITEMS, 3);
        return map;
    }

    private static void addIce(Map<class_1792, Integer> coolTimes, class_6862<class_1792> tag, int coolTime) {
        for (class_6880 registryEntry : class_7923.field_41178.method_40286(tag)) {
            coolTimes.put((class_1792)registryEntry.comp_349(), coolTime);
        }
    }

    private static void addIce(Map<class_1792, Integer> coolTimes, class_1935 item, int coolTime) {
        class_1792 item2 = item.method_8389();
        coolTimes.put(item2, coolTime);
    }

    public static boolean canUseAsIce(class_1799 stack) {
        return FreezerBlockEntity.createCoolTimeMap().containsKey(stack.method_7909());
    }

    private int getCoolTime(class_1799 ice) {
        if (ice.method_7960()) {
            return 0;
        }
        class_1792 item = ice.method_7909();
        return FreezerBlockEntity.createCoolTimeMap().getOrDefault(item, 0);
    }

    private boolean isCool() {
        return this.coolTime > 0;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem(FreezerBlockEntity entity) {
        class_1277 inventory = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory.method_5447(i, entity.method_5438(i));
        }
        Optional match = Objects.requireNonNull(entity.method_10997()).method_8433().method_8132((class_3956)FreezingRecipe.Type.INSTANCE, (class_1263)inventory, entity.method_10997());
        this.experiences += 3;
        this.method_5447(4, new class_1799((class_1935)((FreezingRecipe)match.get()).method_8110(null).method_7909(), this.method_5438(4).method_7947() + ((FreezingRecipe)match.get()).method_8110(null).method_7947()));
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftProgress() {
        ++this.progress;
    }

    private boolean hasRecipe(FreezerBlockEntity entity) {
        class_1277 inventory = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory.method_5447(i, entity.method_5438(i));
        }
        Optional match = Objects.requireNonNull(entity.method_10997()).method_8433().method_8132((class_3956)FreezingRecipe.Type.INSTANCE, (class_1263)inventory, entity.method_10997());
        if (entity.field_11863 != null) {
            return match.isPresent() && this.canInsertAmountIntoOutputSlot(((FreezingRecipe)match.get()).method_8110(null)) && this.canInsertItemIntoOutputSlot(((FreezingRecipe)match.get()).method_8110(entity.field_11863.method_30349()).method_7909());
        }
        return false;
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(4).method_7909() == item || this.method_5438(4).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(4).method_7947() + result.method_7947() <= this.method_5438(4).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(4).method_7960() || this.method_5438(4).method_7947() < this.method_5438(4).method_7914();
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.getItems().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir == class_2350.field_11036 && slot >= 5) {
            return true;
        }
        if (dir == class_2350.field_11043 && slot == 3) {
            return true;
        }
        if (dir == class_2350.field_11039 && slot == 0) {
            return true;
        }
        if (dir == class_2350.field_11035 && slot == 1) {
            return true;
        }
        return dir == class_2350.field_11034 && slot == 2;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return dir == class_2350.field_11033 && slot >= 4;
    }

    public class_1799 getIceSlot() {
        if (this.field_11863 != null) {
            return this.method_5438(3);
        }
        return class_1799.field_8037;
    }

    public class_1799 getCraftSlot() {
        if (this.field_11863 != null) {
            if (this.method_5438(4).method_7960()) {
                return this.method_5438(1);
            }
            return this.method_5438(4);
        }
        return class_1799.field_8037;
    }

    public class_1799 getSlot1() {
        if (this.field_11863 != null) {
            return this.method_5438(5);
        }
        return class_1799.field_8037;
    }

    public class_1799 getSlot2() {
        if (this.field_11863 != null) {
            return this.method_5438(6);
        }
        return class_1799.field_8037;
    }

    public void setExperience(int experiences) {
        this.experiences = experiences;
        this.method_5431();
    }

    public int getExperience() {
        return this.experiences;
    }

    @Override
    public void method_5431() {
        ItemStackSyncS2CPacket.send(this.field_11867, this.getItems(), this.field_11863);
        super.method_5431();
    }

    @Override
    public long getConsumedValue() {
        return 15L;
    }

    @Override
    public boolean isWorking() {
        return !this.isCool();
    }

    @Override
    public void energize() {
        if (!this.isCool()) {
            this.coolTime = 60;
        }
    }
}

