/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.kitchenware;

import com.zombie_cute.mc.bakingdelight.block.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.block.ModBlocks;
import com.zombie_cute.mc.bakingdelight.block.kitchenware.AdvanceFurnaceBlock;
import com.zombie_cute.mc.bakingdelight.block.kitchenware.OvenBlock;
import com.zombie_cute.mc.bakingdelight.block.kitchenware.gas_cooking.gas_cooking_stove.BurningGasCookingStoveBlockEntity;
import com.zombie_cute.mc.bakingdelight.item.ModItems;
import com.zombie_cute.mc.bakingdelight.recipe.custom.BakingRecipe;
import com.zombie_cute.mc.bakingdelight.screen.custom.OvenScreenHandler;
import com.zombie_cute.mc.bakingdelight.util.block_util.ImplementedInventory;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
class_1278 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int INPUT_SLOT_3 = 2;
    private static final int INPUT_SLOT_4 = 3;
    private static final int FUEL_SLOT = 4;
    private static final int OUTPUT_SLOT = 5;
    public static final String OVEN_NAME = "display_name.bakingdelight.oven_name";
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> OvenBlockEntity.this.progress;
                case 1 -> OvenBlockEntity.this.maxProgress;
                case 2 -> OvenBlockEntity.this.burnTime;
                case 3 -> OvenBlockEntity.this.maxBurnTime;
                case 4 -> OvenBlockEntity.this.experiences;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    OvenBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    OvenBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    OvenBlockEntity.this.burnTime = value;
                    break;
                }
                case 3: {
                    OvenBlockEntity.this.maxBurnTime = value;
                    break;
                }
                case 4: {
                    OvenBlockEntity.this.experiences = value;
                }
            }
        }

        public int method_17389() {
            return 5;
        }
    };
    private int progress = 0;
    private int maxProgress = 200;
    private int burnTime = 0;
    private int maxBurnTime = 1;
    private int experiences = 0;
    private int cachedBurnTime = 0;
    private int cachedMaxBurnTime = 0;

    public OvenBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.OVEN_BLOCK_ENTITY, pos, state);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("oven.progress", this.progress);
        nbt.method_10569("oven.fuelTime", this.burnTime);
        nbt.method_10569("oven.maxFuelTime", this.maxBurnTime);
        nbt.method_10569("oven.experiences", this.experiences);
        nbt.method_10569("oven.cachedBurnTime", this.cachedBurnTime);
        nbt.method_10569("oven.cachedMaxBurnTime", this.cachedMaxBurnTime);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("oven.progress");
        this.burnTime = nbt.method_10550("oven.fuelTime");
        this.maxBurnTime = nbt.method_10550("oven.maxFuelTime");
        this.experiences = nbt.method_10550("oven.experiences");
        this.cachedBurnTime = nbt.method_10550("oven.cachedBurnTime");
        this.cachedMaxBurnTime = nbt.method_10550("oven.cachedMaxBurnTime");
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)OVEN_NAME);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new OvenScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        Objects.requireNonNull(this.field_11863).method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, OvenBlockEntity entity) {
        if (world.field_9236) {
            return;
        }
        if (world.method_8321(pos.method_10074()) instanceof BurningGasCookingStoveBlockEntity) {
            if (this.burnTime != 0 && this.cachedBurnTime == 0) {
                this.cachedBurnTime = this.burnTime;
                this.cachedMaxBurnTime = this.maxBurnTime;
            }
            this.burnTime = 1;
            this.maxBurnTime = 1;
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)OvenBlock.OVEN_BURNING, (Comparable)Boolean.valueOf(true)));
            OvenBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            this.checkAndCraft(world, pos, state, entity);
        } else {
            if (this.cachedBurnTime != 0) {
                this.burnTime = this.cachedBurnTime;
                this.maxBurnTime = this.cachedMaxBurnTime;
                this.cachedBurnTime = 0;
                this.cachedMaxBurnTime = 0;
            }
            if (this.isFuelBurning()) {
                --this.burnTime;
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)OvenBlock.OVEN_BURNING, (Comparable)Boolean.valueOf(true)));
                this.checkAndCraft(world, pos, state, entity);
            } else {
                if (this.hasRecipe(entity)) {
                    --this.progress;
                } else {
                    this.resetProgress();
                }
                this.maxBurnTime = 1;
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)OvenBlock.OVEN_BURNING, (Comparable)Boolean.valueOf(false)));
                OvenBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            }
            if (OvenBlockEntity.canUseAsFuel(this.method_5438(4)) && this.burnTime == 0 && this.hasRecipe(entity)) {
                class_1799 fuel = this.method_5438(4);
                this.maxBurnTime = this.burnTime = this.getFuelTime(fuel);
                if (this.method_5438(4).method_7909() == class_1802.field_8187) {
                    this.method_5447(4, class_1802.field_8550.method_7854());
                } else {
                    this.method_5434(4, 1);
                }
            }
        }
    }

    private void checkAndCraft(class_1937 world, class_2338 pos, class_2680 state, OvenBlockEntity entity) {
        if (this.isOutputSlotEmptyOrReceivable()) {
            if (this.hasRecipe(entity)) {
                this.increaseCraftProgress();
                OvenBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.hasCraftingFinished()) {
                    this.craftItem(entity);
                    for (int i = 0; i < 4; ++i) {
                        if (this.method_5438(i).getRecipeRemainder().method_7960()) continue;
                        class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.method_5438(i).getRecipeRemainder().method_7972());
                    }
                    this.method_5434(0, 1);
                    this.method_5434(1, 1);
                    this.method_5434(2, 1);
                    this.method_5434(3, 1);
                    this.resetProgress();
                }
            } else {
                this.resetProgress();
            }
        }
    }

    public static boolean canUseAsFuel(class_1799 stack) {
        return FuelRegistry.INSTANCE.get((class_1935)stack.method_7909()) != null;
    }

    private int getFuelTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        Integer time = (Integer)FuelRegistry.INSTANCE.get((class_1935)fuel.method_7909());
        return time == null ? 0 : time;
    }

    private boolean isFuelBurning() {
        return this.burnTime > 0;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem(OvenBlockEntity entity) {
        if (this.method_5438(0).method_7909().equals(ModItems.BLACK_PEPPER_DUST) && this.method_5438(1).method_7909().equals(class_1802.field_8479) && this.method_5438(2).method_7909().equals(ModItems.BLACK_PEPPER_DUST) && this.method_5438(3).method_7909().equals(ModBlocks.RAW_PIZZA_ITEM)) {
            class_1799 rawPizzaStack = this.method_5438(3);
            class_2487 rawPizzaNBT = class_1747.method_38072((class_1799)rawPizzaStack);
            class_2371 defaultedList = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
            if (rawPizzaNBT != null && rawPizzaNBT.method_10573("Items", 9)) {
                class_1262.method_5429((class_2487)rawPizzaNBT, (class_2371)defaultedList);
            }
            class_1799 pizzaStack = new class_1799((class_1935)ModBlocks.PIZZA_ITEM);
            class_2487 nbt = OvenBlockEntity.getNbtCompound((class_2371<class_1799>)defaultedList);
            class_1747.method_38073((class_1799)pizzaStack, ModBlockEntities.PIZZA_BLOCK_ENTITY, (class_2487)nbt);
            this.method_5447(5, pizzaStack);
        } else {
            class_1277 inventory = new class_1277(entity.method_5439());
            for (int i = 0; i < entity.method_5439(); ++i) {
                inventory.method_5447(i, entity.method_5438(i));
            }
            Optional match = Objects.requireNonNull(entity.method_10997()).method_8433().method_8132((class_3956)BakingRecipe.Type.INSTANCE, (class_1263)inventory, entity.method_10997());
            this.method_5447(5, new class_1799((class_1935)((BakingRecipe)match.get()).method_8110(null).method_7909(), this.method_5438(5).method_7947() + ((BakingRecipe)match.get()).method_8110(null).method_7947()));
        }
        this.experiences += 4;
    }

    @NotNull
    private static class_2487 getNbtCompound(class_2371<class_1799> defaultedList) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < defaultedList.size(); ++i) {
            class_1799 itemStack = (class_1799)defaultedList.get(i);
            if (itemStack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10567("Slot", (byte)i);
            itemStack.method_7953(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtList);
        return nbt;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftProgress() {
        ++this.progress;
    }

    private boolean hasRecipe(OvenBlockEntity entity) {
        if (this.method_5438(0).method_7909().equals(ModItems.BLACK_PEPPER_DUST) && this.method_5438(1).method_7909().equals(class_1802.field_8479) && this.method_5438(2).method_7909().equals(ModItems.BLACK_PEPPER_DUST) && this.method_5438(3).method_7909().equals(ModBlocks.RAW_PIZZA_ITEM) && this.method_5438(5).method_7960()) {
            return true;
        }
        class_1277 inventory = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory.method_5447(i, entity.method_5438(i));
        }
        Optional match = Objects.requireNonNull(entity.method_10997()).method_8433().method_8132((class_3956)BakingRecipe.Type.INSTANCE, (class_1263)inventory, entity.method_10997());
        if (entity.field_11863 != null) {
            return match.isPresent() && this.canInsertAmountIntoOutputSlot(((BakingRecipe)match.get()).method_8110(null)) && this.canInsertItemIntoOutputSlot(((BakingRecipe)match.get()).method_8110(entity.field_11863.method_30349()).method_7909());
        }
        return false;
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(5).method_7909() == item || this.method_5438(5).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(5).method_7947() + result.method_7947() <= this.method_5438(5).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(5).method_7960() || this.method_5438(5).method_7947() < this.method_5438(5).method_7914();
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.getItems().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir == class_2350.field_11036 && slot == 4) {
            return true;
        }
        if (dir == class_2350.field_11034 && slot == 0) {
            return true;
        }
        if (dir == class_2350.field_11035 && slot == 1) {
            return true;
        }
        if (dir == class_2350.field_11039 && slot == 2) {
            return true;
        }
        return dir == class_2350.field_11043 && slot == 3;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (dir == class_2350.field_11033 && slot == 4) {
            return stack.method_31574(class_1802.field_8550);
        }
        return dir == class_2350.field_11033 && slot == 5;
    }

    public void onUse(class_2680 state, class_1937 world) {
        this.playSound(class_3417.field_15026, 2.3f, world.field_9229.method_43057() / 2.0f + 0.5f);
        class_1264.method_5449((class_1937)world, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)ModBlocks.BAKING_TRAY.method_8389().method_7854());
        world.method_8501(this.field_11867, (class_2680)((class_2680)ModBlocks.ADVANCE_FURNACE.method_9564().method_11657((class_2769)AdvanceFurnaceBlock.FACING, (Comparable)((class_2350)state.method_11654((class_2769)OvenBlock.FACING)))).method_11657((class_2769)AdvanceFurnaceBlock.BURNING, (Comparable)Boolean.valueOf(false)));
    }

    public void setExperience(int experiences) {
        this.experiences = experiences;
        this.method_5431();
    }

    public int getExperience() {
        return this.experiences;
    }
}

