/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.kitchenware.gas_cooking.deep_frying;

import com.zombie_cute.mc.bakingdelight.block.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.block.biogas.GasCanisterBlock;
import com.zombie_cute.mc.bakingdelight.block.biogas.GasCanisterBlockEntity;
import com.zombie_cute.mc.bakingdelight.block.kitchenware.gas_cooking.deep_frying.DeepFryerBlock;
import com.zombie_cute.mc.bakingdelight.fluid.ModFluid;
import com.zombie_cute.mc.bakingdelight.item.ModItems;
import com.zombie_cute.mc.bakingdelight.item.tools.HolderItem;
import com.zombie_cute.mc.bakingdelight.networking.packet.ItemStackSyncS2CPacket;
import com.zombie_cute.mc.bakingdelight.recipe.custom.DeepFryingRecipe;
import com.zombie_cute.mc.bakingdelight.screen.custom.DeepFryerScreenHandler;
import com.zombie_cute.mc.bakingdelight.sound.ModSounds;
import com.zombie_cute.mc.bakingdelight.tag.TagKeys;
import com.zombie_cute.mc.bakingdelight.util.FluidStack;
import com.zombie_cute.mc.bakingdelight.util.block_util.ImplementedInventory;
import com.zombie_cute.mc.bakingdelight.util.registry_util.ModDamageTypes;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DeepFryerBlockEntity
extends class_2586
implements ImplementedInventory,
ExtendedScreenHandlerFactory,
class_1278 {
    private int progress1 = 0;
    private int progress2 = 0;
    private int progress3 = 0;
    private int progress4 = 0;
    private int oilLevel = 0;
    public static final int MAX_OIL = 1000;
    public final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 81000L;
        }

        protected void onFinalCommit() {
            DeepFryerBlockEntity.this.method_5431();
        }
    };
    private int isHeated = 0;
    protected final class_3913 propertyDelegate;
    public static final String DEEP_FRYER_NAME = "display_name.bakingdelight.deep_fryer_name";
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public static final String ADD_OIL = "bakingdelight.deep_fryer_message.need_oil";
    public static final String TOO_HOT = "bakingdelight.deep_fryer_message.too_hot";
    int maxProgress = 300;

    public DeepFryerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.DEEP_FRYER_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> DeepFryerBlockEntity.this.progress1;
                    case 1 -> DeepFryerBlockEntity.this.progress2;
                    case 2 -> DeepFryerBlockEntity.this.progress3;
                    case 3 -> DeepFryerBlockEntity.this.progress4;
                    case 4 -> DeepFryerBlockEntity.this.isHeated;
                    case 5 -> DeepFryerBlockEntity.this.oilLevel;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        DeepFryerBlockEntity.this.progress1 = value;
                        break;
                    }
                    case 1: {
                        DeepFryerBlockEntity.this.progress2 = value;
                        break;
                    }
                    case 2: {
                        DeepFryerBlockEntity.this.progress3 = value;
                        break;
                    }
                    case 3: {
                        DeepFryerBlockEntity.this.progress4 = value;
                        break;
                    }
                    case 4: {
                        DeepFryerBlockEntity.this.isHeated = value;
                        break;
                    }
                    case 5: {
                        DeepFryerBlockEntity.this.oilLevel = value;
                    }
                }
            }

            public int method_17389() {
                return 6;
            }
        };
    }

    public void useOnButton(class_2680 state, class_1937 world) {
        if (world.field_9236) {
            return;
        }
        if (!this.isHeated(state)) {
            this.playSound(class_3417.field_14791, 1.0f, 1.0f);
            world.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)DeepFryerBlock.RUNNING, (Comparable)Boolean.valueOf(true)));
        } else {
            this.stopRunning(world, state);
        }
        this.method_5431();
        world.method_8413(this.field_11867, state, state, 2);
    }

    public boolean isBottleVegetableOil(class_1792 item) {
        for (class_6880 registryEntry : class_7923.field_41178.method_40286(TagKeys.BOTTLE_VEGETABLE_OIL)) {
            if (item != registryEntry.comp_349()) continue;
            return true;
        }
        return false;
    }

    public boolean isBucketVegetableOil(class_1792 item) {
        return ModFluid.STILL_VEGETABLE_OIL.method_15774() == item;
    }

    public void onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (world.field_9236) {
            return;
        }
        class_1799 mainHandStack = player.method_6047();
        class_1799 offHandStack = player.method_6079();
        if (!((Boolean)state.method_11654((class_2769)DeepFryerBlock.HAS_OIL)).booleanValue()) {
            if (this.isBottleVegetableOil(offHandStack.method_7909())) {
                this.splitOilItem(world, player, false, class_1802.field_8469);
            } else if (this.isBottleVegetableOil(mainHandStack.method_7909())) {
                this.splitOilItem(world, player, true, class_1802.field_8469);
            } else if (this.isBucketVegetableOil(offHandStack.method_7909())) {
                this.splitOilItem(world, player, false, class_1802.field_8550);
            } else if (this.isBucketVegetableOil(mainHandStack.method_7909())) {
                this.splitOilItem(world, player, true, class_1802.field_8550);
            } else if (this.method_5438(0).method_7960() && this.method_5438(1).method_7960() && this.method_5438(2).method_7960() && this.method_5438(3).method_7960()) {
                player.method_7353((class_2561)class_2561.method_43471((String)ADD_OIL), true);
            } else if (mainHandStack.method_7909() == ModItems.HOLDER) {
                this.setItemOnHolder(mainHandStack);
            } else if (offHandStack.method_7909() == ModItems.HOLDER) {
                this.setItemOnHolder(offHandStack);
            } else {
                this.spawnItemAndTryDamage(world, player, state);
            }
        } else if (mainHandStack.method_7909() == ModItems.HOLDER) {
            this.setItemOnHolder(mainHandStack);
        } else if (offHandStack.method_7909() == ModItems.HOLDER) {
            this.setItemOnHolder(offHandStack);
        } else if (player.method_6079().method_7960()) {
            if (player.method_6047().method_7960()) {
                this.spawnItemAndTryDamage(world, player, state);
            } else {
                this.checkAndPut(true, player, world);
            }
        } else {
            this.checkAndPut(false, player, world);
        }
        this.method_5431();
        world.method_8413(pos, state, state, 2);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    private void spawnItemAndTryDamage(class_1937 world, class_1657 player, class_2680 state) {
        if (this.isHeated(state)) {
            player.method_5643(ModDamageTypes.of(world, ModDamageTypes.SCALDED), 2.0f);
            player.method_7353((class_2561)class_2561.method_43471((String)TOO_HOT), true);
        } else if (((Boolean)state.method_11654((class_2769)DeepFryerBlock.HAS_OIL)).booleanValue()) {
            player.method_5643(ModDamageTypes.of(world, ModDamageTypes.SCALDED), 1.0f);
            player.method_7353((class_2561)class_2561.method_43471((String)TOO_HOT), true);
        }
        this.spawnItem(world);
    }

    private void setItemOnHolder(class_1799 holder) {
        if (HolderItem.getHoldingStack(holder).method_7960()) {
            for (int i = 3; i >= 0; --i) {
                if (this.method_5438(i).method_7960()) continue;
                class_1799 stack = this.method_5438(i).method_7972();
                this.method_5447(i, class_1799.field_8037);
                this.playSound(class_3417.field_15197, 1.0f, 1.0f);
                HolderItem.setHoldingStack(stack, holder);
                break;
            }
        }
        this.method_5431();
    }

    private void spawnItem(class_1937 world) {
        for (int i = 3; i >= 0; --i) {
            if (this.method_5438(i).method_7960()) continue;
            this.spawnItem(i, world);
            break;
        }
    }

    private void spawnItem(int slot, class_1937 world) {
        class_1264.method_5449((class_1937)world, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.8), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)this.method_5438(slot));
        this.method_5447(slot, class_1799.field_8037);
        this.playSound(class_3417.field_15197, 1.3f, world.field_9229.method_43057() + 0.4f);
        this.method_5431();
    }

    private void checkAndPut(boolean isMainHand, class_1657 player, class_1937 world) {
        for (int i = 0; i < 4; ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            this.checkHandAndSplit(isMainHand, player, i, world);
            this.playSound(class_3417.field_15197, 1.0f, world.field_9229.method_43057() + 0.3f);
            break;
        }
    }

    private void checkHandAndDecrement(boolean isMainHand, class_1657 player) {
        if (isMainHand) {
            player.method_6047().method_7934(1);
        } else {
            player.method_6079().method_7934(1);
        }
    }

    private void checkHandAndSplit(boolean isMainHand, class_1657 player, int slot, class_1937 world) {
        if (isMainHand) {
            this.method_5447(slot, player.method_6047().method_7971(1));
        } else {
            this.method_5447(slot, player.method_6079().method_7971(1));
        }
        this.method_5431();
    }

    private void splitOilItem(class_1937 world, class_1657 player, boolean isMainHand, class_1792 item) {
        this.checkHandAndDecrement(isMainHand, player);
        this.playSound(class_3417.field_14834, 1.0f, world.field_9229.method_43057() + 0.3f);
        player.method_7270(item.method_7854());
        if (item.equals(class_1802.field_8469)) {
            try (Transaction transaction = Transaction.openOuter();){
                this.fluidStorage.insert((TransferVariant)FluidVariant.of((class_3611)ModFluid.STILL_VEGETABLE_OIL), this.fluidStorage.getCapacity() / 3L, (TransactionContext)transaction);
                transaction.commit();
            }
        } else if (item.equals(class_1802.field_8550)) {
            this.fluidStorage.variant = FluidVariant.of((class_3611)ModFluid.STILL_VEGETABLE_OIL);
            this.fluidStorage.amount = this.fluidStorage.getCapacity();
        }
    }

    public void tick(class_1937 world, class_2680 state, DeepFryerBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (this.hasOil()) {
            world.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)DeepFryerBlock.HAS_OIL, (Comparable)Boolean.valueOf(true)));
            this.oilLevel = (int)FluidStack.convertDropletsToMb(this.fluidStorage.amount);
        } else {
            this.oilLevel = 0;
            world.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)DeepFryerBlock.HAS_OIL, (Comparable)Boolean.valueOf(false)));
        }
        if (world.method_8510() % 5L == 0L && (this.progress1 != 0 || this.progress2 != 0 || this.progress3 != 0 || this.progress4 != 0)) {
            this.playSound(ModSounds.BLOCK_FOOD_FRYING, 0.4f, 1.0f);
        }
        if (this.isHeated(state)) {
            this.isHeated = 1;
            if (world.method_8510() % 5L == 0L) {
                this.playSound(class_3417.field_14993, 0.3f, 1.0f);
            }
            class_2350 dir = (class_2350)state.method_11654((class_2769)DeepFryerBlock.FACING);
            class_2680 neighborState = class_2246.field_10124.method_9564();
            class_2338 neighborPos = this.field_11867;
            switch (dir) {
                case field_11034: {
                    neighborPos = this.field_11867.method_10093(class_2350.field_11039);
                    neighborState = world.method_8320(neighborPos);
                    break;
                }
                case field_11035: {
                    neighborPos = this.field_11867.method_10093(class_2350.field_11043);
                    neighborState = world.method_8320(neighborPos);
                    break;
                }
                case field_11039: {
                    neighborPos = this.field_11867.method_10093(class_2350.field_11034);
                    neighborState = world.method_8320(neighborPos);
                    break;
                }
                case field_11043: {
                    neighborPos = this.field_11867.method_10093(class_2350.field_11035);
                    neighborState = world.method_8320(neighborPos);
                }
            }
            if (neighborState.method_26204() instanceof GasCanisterBlock) {
                if (neighborState.method_11654((class_2769)GasCanisterBlock.FACING) == dir) {
                    GasCanisterBlockEntity entity;
                    class_2586 neighborBlockEntity = world.method_8321(neighborPos);
                    if (!(neighborBlockEntity instanceof GasCanisterBlockEntity) || !(entity = (GasCanisterBlockEntity)neighborBlockEntity).reduceGas()) {
                        this.stopRunning(world, state);
                    }
                } else {
                    this.stopRunning(world, state);
                }
            } else {
                this.stopRunning(world, state);
            }
            if (((Boolean)state.method_11654((class_2769)DeepFryerBlock.HAS_OIL)).booleanValue()) {
                if (this.hasRecipe(0)) {
                    ++blockEntity.progress1;
                    if (blockEntity.progress1 == this.maxProgress) {
                        this.craft(0, world);
                    }
                } else {
                    blockEntity.progress1 = 0;
                }
                if (this.hasRecipe(1)) {
                    ++blockEntity.progress2;
                    if (blockEntity.progress2 == this.maxProgress) {
                        this.craft(1, world);
                    }
                } else {
                    blockEntity.progress2 = 0;
                }
                if (this.hasRecipe(2)) {
                    ++blockEntity.progress3;
                    if (blockEntity.progress3 == this.maxProgress) {
                        this.craft(2, world);
                    }
                } else {
                    blockEntity.progress3 = 0;
                }
                if (this.hasRecipe(3)) {
                    ++blockEntity.progress4;
                    if (blockEntity.progress4 == this.maxProgress) {
                        this.craft(3, world);
                    }
                } else {
                    blockEntity.progress4 = 0;
                }
            } else {
                this.resetAllProgress();
            }
        } else {
            this.resetAllProgress();
            this.isHeated = 0;
        }
    }

    private boolean hasOil() {
        class_3611 fluid = ((FluidVariant)this.fluidStorage.variant).getFluid();
        for (class_6880 f : class_7923.field_41173.method_40286(TagKeys.OIL)) {
            if (fluid != f.comp_349()) continue;
            return true;
        }
        return false;
    }

    private void craft(int slot, class_1937 world) {
        class_1277 inventory = new class_1277(1);
        inventory.method_5447(0, this.method_5438(slot));
        Optional match = Objects.requireNonNull(this.method_10997()).method_8433().method_8132((class_3956)DeepFryingRecipe.Type.INSTANCE, (class_1263)inventory, this.method_10997());
        if (!this.method_5438(slot).getRecipeRemainder().method_7960()) {
            class_1264.method_5449((class_1937)world, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)this.method_5438(slot).getRecipeRemainder().method_7972());
        }
        this.method_5447(slot, new class_1799((class_1935)((DeepFryingRecipe)match.get()).method_8110(null).method_7909(), ((DeepFryingRecipe)match.get()).method_8110(null).method_7947()));
        this.decreaseOilLevel();
        if (world.method_8510() % 5L == 0L) {
            this.playSound(ModSounds.BLOCK_FOOD_FRYING, 1.0f, 2.0f);
        }
        this.method_5431();
    }

    private void stopRunning(class_1937 world, class_2680 state) {
        this.playSound(class_3417.field_14954, 1.0f, 1.0f);
        world.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)DeepFryerBlock.RUNNING, (Comparable)Boolean.valueOf(false)));
    }

    private void resetAllProgress() {
        this.progress1 = 0;
        this.progress2 = 0;
        this.progress3 = 0;
        this.progress4 = 0;
        this.method_5431();
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        Objects.requireNonNull(this.field_11863).method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    private boolean isHeated(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)DeepFryerBlock.RUNNING);
    }

    private void decreaseOilLevel() {
        if (this.fluidStorage.amount - FluidStack.convertMbToDroplets(50L) > 0L) {
            this.fluidStorage.amount -= FluidStack.convertMbToDroplets(50L);
        } else {
            this.fluidStorage.amount = 0L;
            this.fluidStorage.variant = FluidVariant.blank();
        }
    }

    private boolean hasRecipe(int slot) {
        class_1277 inventory = new class_1277(1);
        inventory.method_5447(0, this.method_5438(slot));
        Optional match = Objects.requireNonNull(this.method_10997()).method_8433().method_8132((class_3956)DeepFryingRecipe.Type.INSTANCE, (class_1263)inventory, this.method_10997());
        return match.isPresent();
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("deep_fryer.progress1", this.progress1);
        nbt.method_10569("deep_fryer.progress2", this.progress2);
        nbt.method_10569("deep_fryer.progress3", this.progress3);
        nbt.method_10569("deep_fryer.progress4", this.progress4);
        nbt.method_10544("deep_fryer.fluid_amount", this.fluidStorage.amount);
        nbt.method_10566("deep_fryer.fluid_variant", (class_2520)((FluidVariant)this.fluidStorage.variant).toNbt());
        nbt.method_10569("deep_fryer.isHeated", this.isHeated);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress1 = nbt.method_10550("deep_fryer.progress1");
        this.progress2 = nbt.method_10550("deep_fryer.progress2");
        this.progress3 = nbt.method_10550("deep_fryer.progress3");
        this.progress4 = nbt.method_10550("deep_fryer.progress4");
        this.fluidStorage.variant = FluidVariant.fromNbt((class_2487)((class_2487)nbt.method_10580("deep_fryer.fluid_variant")));
        this.fluidStorage.amount = nbt.method_10537("deep_fryer.fluid_amount");
        this.isHeated = nbt.method_10550("deep_fryer.isHeated");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public void method_5431() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            ItemStackSyncS2CPacket.send(this.field_11867, this.getItems(), this.field_11863);
        }
        super.method_5431();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)DEEP_FRYER_NAME);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new DeepFryerScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }
}

