/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.kitchenware.ice_cream_maker;

import com.zombie_cute.mc.bakingdelight.block.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.block.ModBlocks;
import com.zombie_cute.mc.bakingdelight.block.kitchenware.ice_cream_maker.IceCreamMakerBlock;
import com.zombie_cute.mc.bakingdelight.item.ModItems;
import com.zombie_cute.mc.bakingdelight.item.food.CreamItem;
import com.zombie_cute.mc.bakingdelight.screen.custom.IceCreamMakerScreenHandler;
import com.zombie_cute.mc.bakingdelight.util.block_util.ImplementedInventory;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.ACConsumer;
import com.zombie_cute.mc.bakingdelight.util.enums.CreamFlavor;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class IceCreamMakerBlockEntity
extends class_2586
implements GeoBlockEntity,
ACConsumer,
ImplementedInventory,
ExtendedScreenHandlerFactory {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final class_3913 propertyDelegate;
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation START = RawAnimation.begin().thenPlay("start");
    private int isPowered = 0;
    private final IceCream iceCream1 = new IceCream();
    private final IceCream iceCream2 = new IceCream();
    private final IceCream iceCream3 = new IceCream();
    private int progress = 0;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private int ticker = 0;
    public static final String NEED_CONE = "bakingdelight.ice_cream_maker.need_cone";
    public static final String NEED_SELECT = "bakingdelight.ice_cream_maker.need_select";

    public IceCreamMakerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.ICE_CREAM_MAKER_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> IceCreamMakerBlockEntity.this.isPowered;
                    case 1 -> IceCreamMakerBlockEntity.this.progress;
                    case 2 -> IceCreamMakerBlockEntity.this.iceCream1.getFlavor().getId();
                    case 3 -> IceCreamMakerBlockEntity.this.iceCream1.getAmount();
                    case 4 -> IceCreamMakerBlockEntity.this.iceCream1.getSelected();
                    case 5 -> IceCreamMakerBlockEntity.this.iceCream2.getFlavor().getId();
                    case 6 -> IceCreamMakerBlockEntity.this.iceCream2.getAmount();
                    case 7 -> IceCreamMakerBlockEntity.this.iceCream2.getSelected();
                    case 8 -> IceCreamMakerBlockEntity.this.iceCream3.getFlavor().getId();
                    case 9 -> IceCreamMakerBlockEntity.this.iceCream3.getAmount();
                    case 10 -> IceCreamMakerBlockEntity.this.iceCream3.getSelected();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
            }

            public int method_17389() {
                return 11;
            }
        };
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (Objects.requireNonNull((Boolean)((IceCreamMakerBlockEntity)state.getAnimatable()).method_11010().method_11654((class_2769)IceCreamMakerBlock.START)).booleanValue()) {
                return state.setAndContinue(START);
            }
            return state.setAndContinue(IDLE);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        if (this.isPowered > 0) {
            --this.isPowered;
        } else if (this.progress > 0) {
            --this.progress;
        }
        if (((Boolean)state.method_11654((class_2769)IceCreamMakerBlock.START)).booleanValue()) {
            ++this.ticker;
            if (this.ticker >= 60) {
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.method_5438(4));
                this.method_5447(4, class_1799.field_8037);
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)IceCreamMakerBlock.START, (Comparable)Boolean.valueOf(false)));
            }
        } else {
            this.ticker = 0;
        }
        if (world.method_8510() % 20L == 0L) {
            class_1792 class_17922 = this.method_5438(0).method_7909();
            if (class_17922 instanceof CreamItem) {
                CreamItem cream = (CreamItem)class_17922;
                CreamFlavor creamFlavor = cream.getFlavor();
                int findNull = this.findNull();
                int findSameFlavor = this.findSameFlavor(creamFlavor);
                if (this.hasRecipe() && (findNull != 0 || findSameFlavor != 0)) {
                    ++this.progress;
                    int maxProgress = 10;
                    if (this.progress >= maxProgress) {
                        if (findSameFlavor != 0) {
                            switch (findSameFlavor) {
                                case 1: {
                                    this.iceCream1.changeAmount(100);
                                    break;
                                }
                                case 2: {
                                    this.iceCream2.changeAmount(100);
                                    break;
                                }
                                case 3: {
                                    this.iceCream3.changeAmount(100);
                                }
                            }
                        } else {
                            switch (findNull) {
                                case 1: {
                                    this.iceCream1.setFlavor(creamFlavor);
                                    this.iceCream1.setAmount(100);
                                    break;
                                }
                                case 2: {
                                    this.iceCream2.setFlavor(creamFlavor);
                                    this.iceCream2.setAmount(100);
                                    break;
                                }
                                case 3: {
                                    this.iceCream3.setFlavor(creamFlavor);
                                    this.iceCream3.setAmount(100);
                                }
                            }
                        }
                        this.method_5434(0, 1);
                        this.method_5434(1, 1);
                        this.method_5434(2, 1);
                        class_1799 stack3 = this.method_5438(3);
                        int count = stack3.method_7947();
                        if (stack3.method_7960()) {
                            this.method_5447(3, class_1802.field_8428.method_7854());
                        } else if (stack3.method_7909() == class_1802.field_8428 && count < stack3.method_7914()) {
                            this.method_5447(3, new class_1799((class_1935)class_1802.field_8428, count + 1));
                        } else {
                            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)new class_1799((class_1935)class_1802.field_8428));
                        }
                        this.progress = 0;
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            this.method_5431();
        }
    }

    private int findSameFlavor(CreamFlavor creamFlavor) {
        if (this.iceCream1.getFlavor() == creamFlavor && this.iceCream1.getAmount() != 1000) {
            return 1;
        }
        if (this.iceCream2.getFlavor() == creamFlavor && this.iceCream2.getAmount() != 1000) {
            return 2;
        }
        if (this.iceCream3.getFlavor() == creamFlavor && this.iceCream3.getAmount() != 1000) {
            return 3;
        }
        return 0;
    }

    private int findNull() {
        if (this.iceCream1.getFlavor().getId() == -1) {
            return 1;
        }
        if (this.iceCream2.getFlavor().getId() == -1) {
            return 2;
        }
        if (this.iceCream3.getFlavor().getId() == -1) {
            return 3;
        }
        return 0;
    }

    private boolean hasRecipe() {
        return this.isPowered != 0 && this.method_5438(1).method_7909() == class_1802.field_8479 && this.method_5438(2).method_7909() == class_1802.field_8803;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("ice_cream_maker.progress", this.progress);
        nbt.method_10569("ice_cream_maker.ice_cream1.flavor", this.iceCream1.getFlavor().getId());
        nbt.method_10569("ice_cream_maker.ice_cream1.amount", this.iceCream1.getAmount());
        nbt.method_10556("ice_cream_maker.ice_cream1.selected", this.iceCream1.isSelected());
        nbt.method_10569("ice_cream_maker.ice_cream2.flavor", this.iceCream2.getFlavor().getId());
        nbt.method_10569("ice_cream_maker.ice_cream2.amount", this.iceCream2.getAmount());
        nbt.method_10556("ice_cream_maker.ice_cream2.selected", this.iceCream2.isSelected());
        nbt.method_10569("ice_cream_maker.ice_cream3.flavor", this.iceCream3.getFlavor().getId());
        nbt.method_10569("ice_cream_maker.ice_cream3.amount", this.iceCream3.getAmount());
        nbt.method_10556("ice_cream_maker.ice_cream3.selected", this.iceCream3.isSelected());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("ice_cream_maker.progress");
        this.iceCream1.setFlavor(CreamFlavor.getFlavorByID(nbt.method_10550("ice_cream_maker.ice_cream1.flavor")));
        this.iceCream1.setAmount(nbt.method_10550("ice_cream_maker.ice_cream1.amount"));
        this.iceCream1.setSelected(nbt.method_10577("ice_cream_maker.ice_cream1.selected"));
        this.iceCream2.setFlavor(CreamFlavor.getFlavorByID(nbt.method_10550("ice_cream_maker.ice_cream2.flavor")));
        this.iceCream2.setAmount(nbt.method_10550("ice_cream_maker.ice_cream2.amount"));
        this.iceCream2.setSelected(nbt.method_10577("ice_cream_maker.ice_cream2.selected"));
        this.iceCream3.setFlavor(CreamFlavor.getFlavorByID(nbt.method_10550("ice_cream_maker.ice_cream3.flavor")));
        this.iceCream3.setAmount(nbt.method_10550("ice_cream_maker.ice_cream3.amount"));
        this.iceCream3.setSelected(nbt.method_10577("ice_cream_maker.ice_cream3.selected"));
    }

    @Override
    public long getConsumedValue() {
        return 20L;
    }

    @Override
    public boolean isWorking() {
        return true;
    }

    @Override
    public void energize() {
        this.isPowered = 100;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return ModBlocks.ICE_CREAM_MAKER.method_9518();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new IceCreamMakerScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tryStart(class_2680 state, class_1937 world, class_1657 player) {
        if (!((Boolean)state.method_11654((class_2769)IceCreamMakerBlock.START)).booleanValue()) {
            if (player.method_6047().method_7909() != ModItems.ICE_CREAM_CONE) {
                player.method_7353((class_2561)class_2561.method_43471((String)NEED_CONE), true);
                return;
            }
            ArrayList<CreamFlavor> creamFlavors = new ArrayList<CreamFlavor>();
            if (this.iceCream1.isSelected() && this.iceCream1.getFlavor() != CreamFlavor.NULL && this.iceCream1.getAmount() >= 50) {
                creamFlavors.add(this.iceCream1.getFlavor());
                this.iceCream1.changeAmount(-50);
            }
            if (this.iceCream2.isSelected() && this.iceCream2.getFlavor() != CreamFlavor.NULL && this.iceCream2.getAmount() >= 50) {
                creamFlavors.add(this.iceCream2.getFlavor());
                this.iceCream2.changeAmount(-50);
            }
            if (this.iceCream3.isSelected() && this.iceCream3.getFlavor() != CreamFlavor.NULL && this.iceCream3.getAmount() >= 50) {
                creamFlavors.add(this.iceCream3.getFlavor());
                this.iceCream3.changeAmount(-50);
            }
            if (creamFlavors.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43471((String)NEED_SELECT), true);
                return;
            }
            class_1799 iceCream = new class_1799((class_1935)ModItems.ICE_CREAM);
            for (CreamFlavor creamFlavor : creamFlavors) {
                CreamFlavor.addFlavorToFood(iceCream, creamFlavor);
            }
            this.method_5447(4, iceCream);
            player.method_6047().method_7934(1);
            world.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)IceCreamMakerBlock.START, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void changeIceCream1() {
        this.iceCream1.setSelected(!this.iceCream1.isSelected());
    }

    public void changeIceCream2() {
        this.iceCream2.setSelected(!this.iceCream2.isSelected());
    }

    public void changeIceCream3() {
        this.iceCream3.setSelected(!this.iceCream3.isSelected());
    }

    public static class IceCream {
        private CreamFlavor creamFlavor;
        private int amount;
        private final int MAX_AMOUNT = 1000;
        private boolean isSelected = false;

        public IceCream(CreamFlavor creamFlavor, int amount) {
            this.creamFlavor = creamFlavor;
            this.amount = amount;
        }

        public IceCream() {
            this.creamFlavor = CreamFlavor.NULL;
            this.amount = 0;
        }

        public CreamFlavor getFlavor() {
            return this.creamFlavor;
        }

        public int getSelected() {
            return this.isSelected ? 1 : 0;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        public void setSelected(int value) {
            this.isSelected = value != 0;
        }

        public void setFlavor(CreamFlavor creamFlavor) {
            this.creamFlavor = creamFlavor;
            if (creamFlavor == CreamFlavor.NULL) {
                this.amount = 0;
            }
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            if (this.creamFlavor != CreamFlavor.NULL) {
                this.amount = amount > 1000 ? 1000 : Math.max(amount, 0);
                if (this.amount == 0) {
                    this.creamFlavor = CreamFlavor.NULL;
                }
            }
        }

        public void changeAmount(int value) {
            if (this.creamFlavor != CreamFlavor.NULL) {
                if (this.amount + value <= 0) {
                    this.amount = 0;
                    this.creamFlavor = CreamFlavor.NULL;
                } else {
                    this.amount = this.amount + value >= 1000 ? 1000 : (this.amount += value);
                }
            }
        }
    }
}

