/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.kitchenware.steaming;

import com.zombie_cute.mc.bakingdelight.block.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.block.kitchenware.steaming.ElectricSteamerBlock;
import com.zombie_cute.mc.bakingdelight.networking.packet.ItemStackSyncS2CPacket;
import com.zombie_cute.mc.bakingdelight.recipe.custom.SteamingRecipe;
import com.zombie_cute.mc.bakingdelight.screen.custom.ElectricSteamerScreenHandler;
import com.zombie_cute.mc.bakingdelight.util.FluidStack;
import com.zombie_cute.mc.bakingdelight.util.block_util.ImplementedInventory;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.ACConsumer;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class ElectricSteamerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
ACConsumer,
class_1278 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)13, (Object)class_1799.field_8037);
    private int cachedPower = 0;
    private final int[] progresses = new int[12];
    private final int[] maxProgresses = new int[12];
    private int water = 0;
    private int steam = 0;
    private int steamProgress = 0;
    public final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.of((class_3611)class_3612.field_15910);
        }

        protected long getCapacity(FluidVariant variant) {
            return 81000L;
        }

        protected void onFinalCommit() {
            ElectricSteamerBlockEntity.this.method_5431();
        }
    };
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            if (index >= 0 && index <= 11) {
                return ElectricSteamerBlockEntity.this.progresses[index];
            }
            if (index >= 12 && index <= 23) {
                return ElectricSteamerBlockEntity.this.maxProgresses[index - 12];
            }
            return switch (index) {
                case 24 -> ElectricSteamerBlockEntity.this.water;
                case 25 -> ElectricSteamerBlockEntity.this.steam;
                case 26 -> ElectricSteamerBlockEntity.this.steamProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return 27;
        }
    };
    public static final int MAX_STEAM_PROGRESS = 60;
    public static final int MAX_WATER_OR_STEAM = 1000;
    public static final int WATER_SLOT = 12;

    public ElectricSteamerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.ELECTRIC_STEAMER_BLOCK_ENTITY, pos, state);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("electric_steamer.cachedPower", this.cachedPower);
        nbt.method_10539("electric_steamer.progresses", this.progresses);
        nbt.method_10566("electric_steamer.fluid_variant", (class_2520)((FluidVariant)this.fluidStorage.variant).toNbt());
        nbt.method_10544("electric_steamer.fluid_amount", this.fluidStorage.amount);
        nbt.method_10569("electric_steamer.steam", this.steam);
        nbt.method_10569("electric_steamer.steamProgress", this.steamProgress);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.cachedPower = nbt.method_10550("electric_steamer.cachedPower");
        int[] temp = nbt.method_10561("electric_steamer.progresses");
        int max = this.progresses.length;
        if (temp.length < max) {
            max = temp.length;
        }
        System.arraycopy(temp, 0, this.progresses, 0, max);
        this.fluidStorage.variant = FluidVariant.fromNbt((class_2487)((class_2487)nbt.method_10580("electric_steamer.fluid_variant")));
        this.fluidStorage.amount = nbt.method_10537("electric_steamer.fluid_amount");
        this.steam = nbt.method_10550("electric_steamer.steam");
        this.steamProgress = nbt.method_10550("electric_steamer.steamProgress");
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        this.water = ((FluidVariant)this.fluidStorage.variant).getFluid() == class_3612.field_15910 ? (int)FluidStack.convertDropletsToMb(this.fluidStorage.amount) : 0;
        if (this.cachedPower > 0) {
            --this.cachedPower;
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)ElectricSteamerBlock.IS_WORKING, (Comparable)Boolean.valueOf(true)));
            if (this.fluidStorage.amount > FluidStack.convertMbToDroplets(50L) && this.steam < 1000 && ((FluidVariant)this.fluidStorage.variant).getFluid() == class_3612.field_15910) {
                ++this.steamProgress;
                if (this.steamProgress >= 60) {
                    this.steamProgress = 0;
                    this.fluidStorage.amount -= FluidStack.convertMbToDroplets(50L);
                    this.steam = this.steam + 80 < 1000 ? (this.steam += 80) : 1000;
                }
            } else {
                this.steamProgress = 0;
            }
        } else {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)ElectricSteamerBlock.IS_WORKING, (Comparable)Boolean.valueOf(false)));
        }
        if (this.method_5438(12).method_7909().equals(class_1802.field_8705) && this.fillWater(world, pos)) {
            this.method_5447(12, class_1802.field_8550.method_7854());
        }
        if (world.method_8510() % 20L == 0L && this.steam > 5) {
            for (int i = 0; i < 12; ++i) {
                class_1277 inventory = new class_1277(new class_1799[]{this.method_5438(i)});
                Optional match = Objects.requireNonNull(this.method_10997()).method_8433().method_8132((class_3956)SteamingRecipe.Type.INSTANCE, (class_1263)inventory, this.method_10997());
                if (match.isPresent()) {
                    int maxProgress = ((SteamingRecipe)match.get()).getMaxProgress();
                    int count = this.method_5438(i).method_7947();
                    this.maxProgresses[i] = count <= 16 ? maxProgress : maxProgress * count / 16;
                    if (this.progresses[i] < this.maxProgresses[i]) {
                        int n = i;
                        this.progresses[n] = this.progresses[n] + 1;
                        this.steam -= 5;
                        continue;
                    }
                    this.progresses[i] = 0;
                    this.maxProgresses[i] = 0;
                    this.method_5447(i, new class_1799((class_1935)((SteamingRecipe)match.get()).method_8110(null).method_7909(), count));
                    continue;
                }
                this.progresses[i] = 0;
                this.maxProgresses[i] = 0;
            }
            this.method_5431();
        }
    }

    @Override
    public void method_5431() {
        ItemStackSyncS2CPacket.send(this.field_11867, this.getItems(), this.field_11863);
        super.method_5431();
    }

    public boolean fillWater(class_1937 world, class_2338 pos) {
        if (((FluidVariant)this.fluidStorage.variant).getFluid() == FluidVariant.blank() || this.fluidStorage.amount < this.fluidStorage.getCapacity() && ((FluidVariant)this.fluidStorage.variant).getFluid() == class_3612.field_15910) {
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
            this.fluidStorage.variant = FluidVariant.of((class_3611)class_3612.field_15910);
            this.fluidStorage.amount = this.fluidStorage.getCapacity();
            return true;
        }
        return false;
    }

    @Override
    public long getConsumedValue() {
        return 10L;
    }

    @Override
    public boolean isWorking() {
        return true;
    }

    @Override
    public void energize() {
        this.cachedPower = 60;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)" ");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ElectricSteamerScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.getItems().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir == class_2350.field_11036 && slot >= 0 && slot <= 11) {
            return true;
        }
        return (dir == class_2350.field_11034 || dir == class_2350.field_11035 || dir == class_2350.field_11039 || dir == class_2350.field_11043) && slot == 12;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }
}

