/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.power.alternator;

import com.zombie_cute.mc.bakingdelight.block.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.block.ModBlocks;
import com.zombie_cute.mc.bakingdelight.block.power.alternator.ACDCConverterBlock;
import com.zombie_cute.mc.bakingdelight.block.power.alternator.thermal_power.FaradayGeneratorBlock;
import com.zombie_cute.mc.bakingdelight.block.power.alternator.thermal_power.FaradayGeneratorBlockEntity;
import com.zombie_cute.mc.bakingdelight.block.power.alternator.wind_power.WindTurbineControllerBlock;
import com.zombie_cute.mc.bakingdelight.block.power.alternator.wind_power.WindTurbineControllerBlockEntity;
import com.zombie_cute.mc.bakingdelight.block.power.batteries.AbstractBatteryBlock;
import com.zombie_cute.mc.bakingdelight.screen.custom.ACDCConverterScreenHandler;
import com.zombie_cute.mc.bakingdelight.util.ModConfig;
import com.zombie_cute.mc.bakingdelight.util.block_util.ImplementedInventory;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.ACConsumer;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.ACGenerateAble;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.Power;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.PowerStorageAble;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class ACDCConverterBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
PowerStorageAble,
ACGenerateAble,
ACConsumer {
    private int efficiency = 0;
    private final Power power = new Power(3000L);
    private final class_2371<class_1799> INV = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    public final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(30000L, 10000L, 10000L){

        protected void onFinalCommit() {
            ACDCConverterBlockEntity.this.method_5431();
        }
    };
    private int isACMode = 0;
    private int workSpeed = 0;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> (int)ACDCConverterBlockEntity.this.getPowerValue();
                case 1 -> (int)ACDCConverterBlockEntity.this.getPower().getMaxPower();
                case 2 -> ACDCConverterBlockEntity.this.isACMode;
                case 3 -> ACDCConverterBlockEntity.this.workSpeed;
                case 4 -> ACDCConverterBlockEntity.this.getMaxWorkSpeed();
                case 5 -> ACDCConverterBlockEntity.this.efficiency;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    ACDCConverterBlockEntity.this.setPower(value);
                    break;
                }
                case 2: {
                    ACDCConverterBlockEntity.this.isACMode = value;
                    break;
                }
                case 3: {
                    ACDCConverterBlockEntity.this.workSpeed = value;
                    break;
                }
                case 5: {
                    ACDCConverterBlockEntity.this.efficiency = value;
                }
            }
        }

        public int method_17389() {
            return 6;
        }
    };

    public ACDCConverterBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.AC_DC_CONVERTER_BLOCK_ENTITY, pos, state);
    }

    public boolean getIsACMode() {
        return this.isACMode != 0;
    }

    public void setACMode(boolean value) {
        this.isACMode = value ? 1 : 0;
    }

    public int getWorkSpeed() {
        return this.workSpeed;
    }

    public int getMaxWorkSpeed() {
        try {
            int max_speed = ModConfig.acdcConverterMaxWorkSpeed;
            if (max_speed >= 1) {
                return max_speed;
            }
            return 20;
        }
        catch (Throwable ignored) {
            return 20;
        }
    }

    public void addWorkSpeed(int value) {
        this.workSpeed = this.workSpeed + value >= this.getMaxWorkSpeed() ? this.getMaxWorkSpeed() : (this.workSpeed += value);
    }

    public void reduceWorkSpeed(int value) {
        this.workSpeed = this.workSpeed - value <= 0 ? 0 : (this.workSpeed -= value);
    }

    public void tick(class_1937 world, ACDCConverterBlockEntity blockEntity, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        blockEntity.getPower().setPowerValue(this.energyStorage.amount / 10L);
        if (world.method_8510() % 20L == 0L) {
            class_1799 itemStack = blockEntity.method_5438(0);
            if (blockEntity.getIsACMode()) {
                blockEntity.method_5447(0, AbstractBatteryBlock.changeBatteryPower(itemStack, blockEntity.energyStorage, 10L * (long)blockEntity.workSpeed, false));
                if (blockEntity.getPowerValue() <= 0L) {
                    blockEntity.efficiency = 0;
                } else if (blockEntity.getPowerValue() - (long)blockEntity.workSpeed * 10L > 0L) {
                    blockEntity.reduceEnergy((long)blockEntity.workSpeed * 10L * 10L);
                    blockEntity.efficiency = blockEntity.workSpeed * 10;
                } else {
                    blockEntity.reduceEnergy(10L);
                    blockEntity.efficiency = 1;
                }
            } else {
                blockEntity.efficiency = 0;
                blockEntity.method_5447(0, AbstractBatteryBlock.changeBatteryPower(itemStack, blockEntity.energyStorage, 10L * (long)blockEntity.workSpeed, true));
                class_2350 thisDir = (class_2350)state.method_11654((class_2769)ACDCConverterBlock.FACING);
                ACGenerateAble inputBlock = null;
                switch (thisDir) {
                    case field_11034: 
                    case field_11039: {
                        ACGenerateAble entity;
                        ACGenerateAble entity2;
                        class_2586 class_25862 = world.method_8321(this.field_11867.method_10095());
                        if (class_25862 instanceof ACGenerateAble && (entity2 = (ACGenerateAble)class_25862).getEfficiency() != 0L) {
                            if (!blockEntity.checkACGeneratorType(world.method_8321(this.field_11867.method_10095()), world, class_2350.field_11043)) break;
                            inputBlock = entity2;
                            break;
                        }
                        class_25862 = world.method_8321(this.field_11867.method_10072());
                        if (!(class_25862 instanceof ACGenerateAble) || (entity = (ACGenerateAble)class_25862).getEfficiency() == 0L || !blockEntity.checkACGeneratorType(world.method_8321(this.field_11867.method_10072()), world, class_2350.field_11035)) break;
                        inputBlock = entity;
                        break;
                    }
                    case field_11035: 
                    case field_11043: {
                        ACGenerateAble entity;
                        ACGenerateAble entity3;
                        class_2586 class_25863 = world.method_8321(this.field_11867.method_10067());
                        if (class_25863 instanceof ACGenerateAble && (entity3 = (ACGenerateAble)class_25863).getEfficiency() != 0L) {
                            if (!blockEntity.checkACGeneratorType(world.method_8321(this.field_11867.method_10067()), world, class_2350.field_11039)) break;
                            inputBlock = entity3;
                            break;
                        }
                        class_25863 = world.method_8321(this.field_11867.method_10078());
                        if (!(class_25863 instanceof ACGenerateAble) || (entity = (ACGenerateAble)class_25863).getEfficiency() == 0L || !blockEntity.checkACGeneratorType(world.method_8321(this.field_11867.method_10078()), world, class_2350.field_11034)) break;
                        inputBlock = entity;
                    }
                }
                if (inputBlock != null && blockEntity.workSpeed != 0) {
                    blockEntity.addEnergy((long)((double)inputBlock.getEfficiency() * (1.0 - (double)blockEntity.workSpeed / ((double)this.getMaxWorkSpeed() * 3.0))) * 10L);
                }
            }
        }
    }

    private boolean checkACGeneratorType(class_2586 blockEntity, class_1937 world, class_2350 dirType) {
        if (blockEntity instanceof FaradayGeneratorBlockEntity) {
            return world.method_8320(blockEntity.method_11016()).method_11654((class_2769)FaradayGeneratorBlock.FACING) == dirType.method_10153();
        }
        if (blockEntity instanceof WindTurbineControllerBlockEntity) {
            return world.method_8320(blockEntity.method_11016()).method_11654((class_2769)WindTurbineControllerBlock.FACING) == dirType;
        }
        if (blockEntity instanceof ACDCConverterBlockEntity) {
            class_2350 temp = null;
            switch (dirType) {
                case field_11034: 
                case field_11039: {
                    temp = class_2350.field_11043;
                    break;
                }
                case field_11035: 
                case field_11043: {
                    temp = class_2350.field_11034;
                }
            }
            if (temp == null) {
                return false;
            }
            return world.method_8320(blockEntity.method_11016()).method_11654((class_2769)WindTurbineControllerBlock.FACING) == temp || world.method_8320(blockEntity.method_11016()).method_11654((class_2769)WindTurbineControllerBlock.FACING) == temp.method_10153();
        }
        return false;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.INV);
        nbt.method_10544("acdcc.power", this.getPowerValue());
        nbt.method_10569("acdcc.isOpen", this.isACMode);
        nbt.method_10569("acdcc.workSpeed", this.workSpeed);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.INV);
        this.setPower(nbt.method_10537("acdcc.power"));
        this.workSpeed = nbt.method_10550("acdcc.workSpeed");
        this.isACMode = nbt.method_10550("acdcc.isOpen");
        this.energyStorage.amount = nbt.method_10537("acdcc.power") * 10L;
        this.method_5431();
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return ModBlocks.AC_DC_CONVERTER.method_9518();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ACDCConverterScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.INV;
    }

    @Override
    public Power getPower() {
        return this.power;
    }

    @Override
    public SimpleEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public long getEfficiency() {
        return this.efficiency;
    }

    @Override
    public long getConsumedValue() {
        return (long)this.workSpeed * 10L;
    }

    @Override
    public boolean isWorking() {
        return !this.getIsACMode() && this.workSpeed != 0;
    }

    @Override
    public void energize() {
        this.addEnergy((long)((double)this.getWorkSpeed() * 10.0 * (1.0 - (double)this.getWorkSpeed() / ((double)this.getMaxWorkSpeed() * 3.0))) * 3L);
    }
}

